/*
 * misc.c
 *
 * Miscellaneous routines for the PICHEX package.
 *
 * Revision history:
 *
 * 11-Jul-1996: V-0.0; wrote definitions
 * 18-Jul-1996: V-0.1; changed to support LIBVERSION
 *
 * Copyright (C) 1996 David Tait.  All rights reserved.
 * Permission is granted to use, modify, or redistribute this software
 * so long as it is not sold or used for profit.
 *
 * THIS SOFTWARE IS PROVIDED AS IS AND WITHOUT WARRANTY OF ANY KIND,
 * EITHER EXPRESSED OR IMPLIED.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "hex.h"
#ifdef LIBVERSION
#undef LIBVERSION
#endif
#include "misc.h"

static char *version = "misc.c V-0.1  Copyright (C) 1996 David Tait";

static char *osc[] = { "LP_OSC", "XT_OSC", "HS_OSC", "RC_OSC" };

char errmsg[80];       /* used by LIBVERSION quit() macro */


void quit(char *pname, char *msg)
{
    fprintf(stderr,"%s: %s\n",pname,msg);
    exit(EXIT_FAILURE);
}


void telluser(char *pname, char *msg, int e)
{
    fprintf(stderr,"%s: %s\n",pname,msg);
    if ( e < 0 )
	quit( pname, errhex(e) );
    else if ( e > 0 )
	fprintf(stderr,"%s: (Warning) %s\n",pname,errhex(e));
}


void showcf(FILE *fp)
{
    fprintf(fp,"Config: %s,%s,%s,%s\n",
	(config&CP)? "CP_OFF": "CP_ON",
	    (config&PWRT)? "PWRT_ON": "PWRT_OFF",
		(config&WDT)? "WDT_ON": "WDT_OFF",
		    osc[config&OSC]);
}


void showid(FILE *fp)
{
    fprintf(fp,"ID words: %04X %04X %04X %04X\n",
	idbuf[0], idbuf[1], idbuf[2], idbuf[3]);
}


/* hex2int(n,s)
 *
 * Converts at most n chars from a hex string to an integer between 0
 * and 0x7FFF ignoring overflow.  Returns a partial result if white-space
 * is encountered, and -1 for other non-hex chars.
 *
 */

int hex2int(int n, char *s)
{
    int i, b, w = 0;

    for ( i=0; i<n; ++i ) {
	if ( (b = *s++) == '\0' || b == '\n' || b == ' ' )
	    break;
	if (b >= '0' && b <= '9')
	    b -= '0';
	else if (b >= 'a' && b <= 'f')
	    b -= 'a' - 10;
	else if (b >= 'A' && b <= 'F')
	    b -= 'A' - 10;
	else
	    return -1;
	w = (w<<4) + b;
    }
    return w&0x7FFF;
}


/* check84()
 *
 * Implements Microchip's checksum algorithm for the PIC16C84.
 *
 */

unsigned check84(void)
{
    int i;
    U16 c = 0, w;

    if ( config&CP ) {                  /* code protection off */
	for ( i=0; i<1024; ++i )
	    c += progbuf[i];
	c += config;
    } else {                            /* code protection on */
	for ( i=0; i<1024; ++i ) {
	    w = progbuf[i];
	    c += (~(w^(w>>7)))&0x7F;
	}
	c += (config&0x7F);
    }
    return c;
}


unsigned checkall(void)
{
    int i;
    U16 c = 0;

    for ( i=0; i<PSIZE; ++i )
	c += progbuf[i];

    for ( i=0; i<DSIZE; ++i )
	c += databuf[i];

    c += config&CMASK;
    return c;
}

