;Example program for PIC16C84, by Derren Crome
;Will light an LED connected to bits 0-3 of port B (pins 6 to 9) in turn.
;
;Modified (26/Nov/96) by David Tait for MPASM.  To use run:
;
;    MPASM EXAMPLE.ASM
;    SENDHEX EXAMPLE

#DEFINE PAGE0   BCF 3,5
#DEFINE PAGE1   BSF 3,5

	PROCESSOR    16C84

STATUS  EQU     3               ;Located in page 0 & 1
PCL     EQU     2               ;0 & 1
TMR0    EQU     1               ;0
PORTA   EQU     5               ;0
PORTB   EQU     6               ;0
TRISA   EQU     5               ;1
TRISB   EQU     6               ;1
OPTREG  EQU     1               ;1
INTCON  EQU     0BH             ;0 & 1
EEDATA  EQU     8               ;0
EEADR   EQU     9               ;0
EECON   EQU     8               ;1
PCLATH  EQU     0AH             ;0 & 1

W       EQU     0               ;Result to go into working register (accumulator)
F       EQU     1               ;Result to go into a file register.

C       EQU     0               ;Carry flag  (located in STATUS register)
DC      EQU     1               ;Digit carry            "
Z       EQU     2               ;Zero flag              "
PD      EQU     3               ;Power Down bit         "
TO      EQU     4               ;Time-out bit           "


	ORG     0               ;Start of program memory    
	GOTO    5
;
	ORG     4               ;Interupt vector address
	GOTO    INTRPT          ;Jump to interupt service routine on interupt
;
	ORG     5               
	PAGE1                   ;Defined above.
	MOVLW   0               ;Load working register (accumulator) with literal 0.
	MOVWF   TRISB           ;Configure all port B lines as output
	CLRWDT                  ;Clear watchdog timer
	MOVLW   B'00000111'     ;Configure timer options
	MOVWF   OPTREG
	PAGE0
	MOVLW   8
	MOVWF   PORTB           ;Set bit 3 on port B
	MOVLW   B'10100000'
	MOVWF   INTCON          ;Enable timer interrupt

START   NOP                     ;Dummy main program, loops endlessly waiting
	GOTO    START           ;  for a timer interrupt to occur.

;Interupt routine
INTRPT  RRF     PORTB,F         ;Set next bit of port B
	MOVF    PORTB,F         ;affect Z status bit
	BTFSS   STATUS,Z        ;test to see if port B's value=0
	GOTO    FIN             ;It's value is not 0
	MOVLW   8               ;It's value is zero, Set bit 3 of port B
	MOVWF   PORTB           ;Output value to portB
FIN     BCF     INTCON,2        ;Clear timer overflow interupt flag
	RETFIE                  ;Return from interupt
	END                     ;This command MUST be placed at end of program.
