; **************************************************************************
;                                 WIN_TEST.ASM
;               PIC16C84 Software Listing for Naughts and Crosses
; **************************************************************************


;   Organisation : P H Research (Tel/Fax: 01954 200411)
;   Originator   : Paul T.B. Hackett (email: paul@ph-research.prestel.co.uk)
;                                    (mobile: 0410 169361)

;   Version      : 1.0


;   Description


; **************************************************************************


Win_Test                                ; Test for winning line/lines and take action

                                        ; NOTE  x = red
                                        ;       o = green


            ; First test the columns ...

            MOVF        COL1,w          ; \
            XORLW       00010101B       ;  \            x??
            BTFSC       _z              ;  / Test for   x??
            CALL        R_WIN_1         ; /             x??

            MOVF        COL1,w          ; \
            XORLW       00101010B       ;  \            o??
            BTFSC       _z              ;  / Test for   o??
            CALL        G_WIN_1         ; /             o??

            MOVF        COL2,w          ; \
            XORLW       00010101B       ;  \            ?x? 
            BTFSC       _z              ;  / Test for   ?x? 
            CALL        R_WIN_2         ; /             ?x?

            MOVF        COL2,w          ; \
            XORLW       00101010B       ;  \            ?o?
            BTFSC       _z              ;  / Test for   ?o?
            CALL        G_WIN_2         ; /             ?o?

            MOVF        COL3,w          ; \
            XORLW       00010101B       ;  \            ??x
            BTFSC       _z              ;  / Test for   ??x
            CALL        R_WIN_3         ; /             ??x

            MOVF        COL3,w          ; \
            XORLW       00101010B       ;  \            ??o
            BTFSC       _z              ;  / Test for   ??o
            CALL        G_WIN_3         ; /             ??o

            ; ... then the rows ...                

            MOVF        COL1,w          ;
            ANDWF       COL2,w          ;
            ANDWF       COL3,w          ;
            MOVWF       COL_TST         ;

            BTFSC       COL_TST,bit0    ; \
            CALL        R_WIN4          ; / Test top row (x)

            BTFSC       COL_TST,bit1    ; \
            CALL        G_WIN4          ; / Test top row (o)

            BTFSC       COL_TST,bit2    ; \
            CALL        R_WIN5          ; / Test middle row (x)

            BTFSC       COL_TST,bit3    ; \
            CALL        G_WIN5          ; / Test middle row (o)

            BTFSC       COL_TST,bit4    ; \
            CALL        R_WIN6          ; / Test bottom row (x)

            BTFSC       COL_TST,bit5    ; \
            CALL        G_WIN6          ; / Test bottom row (o)

            ; ... and finally the diagonals

            BTFSS       COL1,bit0       ; 
            GOTO        R_WIN8_TST      ; \
            BTFSS       COL2,bit2       ;  \           x
            GOTO        R_WIN8_TST      ;   \ Test for  x
            BTFSS       COL3,bit4       ;   /            x
            GOTO        R_WIN8_TST      ;  /
            CALL        R_WIN7          ; /

R_WIN8_TST  BTFSS       COL1,bit4       ;
            GOTO        G_WIN7_TST      ; \
            BTFSS       COL2,bit2       ;  \             x
            GOTO        G_WIN7_TST      ;   \ Test for  x
            BTFSS       COL3,bit0       ;   /          x
            GOTO        G_WIN7_TST      ;  /
            CALL        R_WIN8          ; /

G_WIN7_TST  BTFSS       COL1,bit1       ;
            GOTO        G_WIN8_TST      ; \
            BTFSS       COL2,bit3       ;  \           o
            GOTO        G_WIN8_TST      ;   \ Test for  o
            BTFSS       COL3,bit5       ;   /            o
            GOTO        G_WIN8_TST      ;  /
            CALL        G_WIN7          ; /

G_WIN8_TST  BTFSS       COL1,bit5       ;
            GOTO        Win_T_End       ; \
            BTFSS       COL2,bit3       ;  \             o
            GOTO        Win_T_End       ;   \ Test for  o
            BTFSS       COL3,bit1       ;   /          o
            GOTO        Win_T_End       ;  /
            CALL        G_WIN8          ; /

Win_T_End   CALL        Win_Flash       ; Test for winning line/lines and flash

            RETURN                      ; Return from subroutine


; **************************************************************************


            ;       7 1  2  3 8
            ;        \V  V  V/
            ;       4>*..*..*
            ;       5>*..*..*
            ;       6>*..*..*


            ; **************************

R_WIN_1     BSF         COL1_MSK,bit0
            BSF         COL1_MSK,bit2
            BSF         COL1_MSK,bit4
            RETURN

            ; **************************

R_WIN_2     BSF         COL2_MSK,bit0
            BSF         COL2_MSK,bit2
            BSF         COL2_MSK,bit4
            RETURN

            ; **************************

R_WIN_3     BSF         COL3_MSK,bit0
            BSF         COL3_MSK,bit2
            BSF         COL3_MSK,bit4
            RETURN

            ; **************************

G_WIN_1     BSF         COL1_MSK,bit1
            BSF         COL1_MSK,bit3
            BSF         COL1_MSK,bit5
            RETURN

            ; **************************

G_WIN_2     BSF         COL2_MSK,bit1
            BSF         COL2_MSK,bit3
            BSF         COL2_MSK,bit5
            RETURN

            ; **************************

G_WIN_3     BSF         COL3_MSK,bit1
            BSF         COL3_MSK,bit3
            BSF         COL3_MSK,bit5
            RETURN

            ; **************************

R_WIN4      BSF         COL1_MSK,bit0
            BSF         COL2_MSK,bit0
            BSF         COL3_MSK,bit0
            RETURN

            ; **************************

R_WIN5      BSF         COL1_MSK,bit2
            BSF         COL2_MSK,bit2
            BSF         COL3_MSK,bit2
            RETURN

            ; ************************** 

R_WIN6      BSF         COL1_MSK,bit4
            BSF         COL2_MSK,bit4
            BSF         COL3_MSK,bit4
            RETURN

            ; **************************

G_WIN4      BSF         COL1_MSK,bit1
            BSF         COL2_MSK,bit1
            BSF         COL3_MSK,bit1
            RETURN

            ; **************************

G_WIN5      BSF         COL1_MSK,bit3
            BSF         COL2_MSK,bit3
            BSF         COL3_MSK,bit3
            RETURN

            ; **************************

G_WIN6      BSF         COL1_MSK,bit5
            BSF         COL2_MSK,bit5
            BSF         COL3_MSK,bit5
            RETURN

            ; **************************

R_WIN7      BSF         COL1_MSK,bit0
            BSF         COL2_MSK,bit2
            BSF         COL3_MSK,bit4
            RETURN

            ; **************************

R_WIN8      BSF         COL1_MSK,bit4
            BSF         COL2_MSK,bit2
            BSF         COL3_MSK,bit0
            RETURN

            ; **************************

G_WIN7      BSF         COL1_MSK,bit1
            BSF         COL2_MSK,bit3
            BSF         COL3_MSK,bit5
            RETURN

            ; **************************

G_WIN8      BSF         COL1_MSK,bit5
            BSF         COL2_MSK,bit3
            BSF         COL3_MSK,bit1
            RETURN


; **************************************************************************


Win_Flash                               ; Test for winning line/lines and flash

            MOVLW       40              ;
            MOVWF       TIMER4          ; Load Timer 4 with 400mS

            MOVF        COL1_MSK,f      ;
            BTFSS       _z              ; Test for winner
            GOTO        Tog_Wait        ; If winner then goto Tog_Wait else contine

            MOVF        COL2_MSK,f      ;
            BTFSS       _z              ; Test for winner
            GOTO        Tog_Wait        ; If winner then goto Tog_Wait else contine

            MOVF        COL3_MSK,f      ;
            BTFSS       _z              ; Test for winner
            GOTO        Tog_Wait        ; If winner then goto Tog_Wait else contine

            RETURN                      ; Return from subroutine (no winner)


Toggle      MOVF        COL1_MSK,w      ;
            XORWF       COL1,f          ;
            MOVF        COL2_MSK,w      ;
            XORWF       COL2,f          ;
            MOVF        COL3_MSK,w      ;
            XORWF       COL3,f          ; Toggle winning line/lines

            MOVLW       25              ;
            MOVWF       TIMER4          ; Load Timer 4 with 250mS

Tog_Wait    MOVF        TIMER4,f        ;
            BTFSS       _z              ;
            GOTO        Tog_Wait        ; Wait for 250mS

            GOTO        Toggle          ; Repeat continuous loop


; **************************************************************************
; **************************************************************************