            list        C=170,F=INHX8M,N=55,P=16C84,R=DEC


; **************************************************************************
;                                  GAME1.ASM
;               PIC16C84 Software Listing for Naughts and Crosses
; **************************************************************************


;   Organisation : P H Research (Tel/Fax: 01954 200411)
;   Originator   : Paul T.B. Hackett (email: paul@ph-research.prestel.co.uk)
;                                    (mobile: 0410 169361)

;   Date         : 18-12-97
;   Version      : 1.1


;   Description


; **************************************************************************


;   Hardware Interface Description  -  PIC16C84


;   Port    IC Pin   Software     Port    Funtional Description
;   Name    Number   Reference   Config

;   RA0       17      _ra0         O      Column Drive 1 (0 - off, 1 - on)
;   RA1       18      _ra1         O      Column Drive 2 (0 - off, 1 - on)
;   RA2        1      _ra2         O      Column Drive 3 (0 - off, 1 - on)
;   RA3        2      _ra3         O      Spare
;   RA4/RTCC   3      _ra4         O      Spare

;   RB0/INT    6      _rb0         I/O    Row Drive 1-Red   (1 - on, 0 - off)
;   RB1        7      _rb1         I/O    Row Drive 1-Green (1 - on, 0 - off)
;   RB2        8      _rb2         I/O    Row Drive 2-Red   (1 - on, 0 - off)
;   RB3        9      _rb3         O      Row Drive 2-Green (1 - on, 0 - off)
;   RB4       10      _rb4         O      Row Drive 3-Red   (1 - on, 0 - off)
;   RB5       11      _rb5         O      Row Drive 3-Green (1 - on, 0 - off)
;   RB6       12      _rb6         O      Spare
;   RB7       13      _rb7         O      Spare


;   Port Config
;   I - Input, O - Output, I/O - Input/Output (Bi-directional)


; **************************************************************************


;   Define Variables

            INCLUDE     "pic16c84.h"    ; Define symbols


;           ******************************************************


; Software Timers

; Timers 1 and 2 are 1 mS to 255 mS timers.  The values loaded into these
; timers are decremented at 1 mS intervals whilst the values remain non-zero.
; An elapsed time is therefore measured by loading the desired timer with the
; required period in mS and then testing its value for zero each time around
; the main program loop.

; Timers 4 and 5 are 10 mS to 2.55 Sec timers and are decremented at 10 mS
; intervals when their values are non-zero.

; Timer 7 is a 100 mS to 25.5 Sec timer and is decremented at 100 mS
; intervals when its value is non-zero.

; Timers 3 and 6 are used by the software timer subroutine to provide the
; 10 mS and 100 mS interval timers.

TIMER1      equ         2FH             ; Used by '' subroutine
TIMER2      equ         2EH             ; Used by '' subroutine
TIMER3      equ         2DH             ; Used by 'SW_Timer' subroutine
TIMER4      equ         2CH             ; Used by '' subroutine
TIMER5      equ         2BH             ; Used by '' subroutine
TIMER6      equ         2AH             ; Used by 'SW_Timer' subroutine
TIMER7      equ         29H             ; Used by '' subroutine


;           ******************************************************


; Keypad Scan

; The keypad matrix is scanned at 4 mS intervals to accomodate switch
; bounce.  The following variables are used by the 'Key_Scan' subroutine
; to provide reliable debounced signals to the control software.

KEY_VAL     equ         28H             ; Latest keypad reading (t=0mS)
KVAL_OLD    equ         27H             ; Last keypad reading (t=-4mS)
KEY_FLGS    equ         26H             ; Debounced control signals


;           ******************************************************


; Front Panel Display

; The display variables 'COL1', 'COL2' and 'COL3' correspond to the columns
; of the led matrix, and are used by the 'Disp_Scan' subroutine to illuminate
; the appropriate leds.  To illuminate an LED the corresponding bit should
; be set, and similarly cleared to extinguish it.


;           7      6      5      4      3      2      1      0

;   COL1    X      X   G(1,3) R(1,3) G(1,2) R(1,2) G(1,1) R(1,1)
;   COL2    X      X   G(2,3) R(2,3) G(2,2) R(2,2) G(2,1) R(2,1)
;   COL3    X      X   G(3,3) R(3,3) G(3,2) R(3,2) G(3,1) R(3,1)


COL1        equ         25H
COL2        equ         24H
COL3        equ         23H

; **************************************************************************


; Other variables

COL_TST     equ         22H             ; Storage for COL1, COL2 and COL3 logical AND result

COL1_MSK    equ         21H             ; Storage for winning line
COL2_MSK    equ         20H             ;
COL3_MSK    equ         1FH             ;

W_TEMP      equ         1DH             ; Storage for wreg during interrupt service
S_TEMP      equ         1CH             ; Storage for status during interrupt service



; **************************************************************************
; **************************************************************************


            ORG         RST_Vec         ; Reset Vector Address PIC16C85
            GOTO        Reset           ;


; **************************************************************************


            ORG         INT_Vec         ; Interrupt Vector Address PIC16C85
            CALL        Int_Serv        ; Serive Interrupt
            RETFIE                      ; Return from interrupt


; **************************************************************************


Reset       Call        Init            ; Initialise microcontroller

Main_Loop   

            CALL        Key_Action      ; Test for key press and take action
            CALL        Win_Test        ; Test for winning line and take action
            GOTO        Main_Loop       ;


; **************************************************************************
; **************************************************************************


RTCC_INIT   equ         179             ; RTCC initialisation value

Init                                    ; Initialisation subroutine

            BSF         _rp0            ; Select page 1
            MOVLW       10000000B       ; Load wreg with desired configuration
;                            |||----      Prescaler for RTCC = 1/2
;                           |-------      Prescaler assigned to RTCC
;                          |--------      RTCC signal edge = +ve
;                         |---------      RTCC signal source = Internal
;                        |---------       INT interrupt edge = falling
;                       |---------        Port B pull-ups = disabled
            MOVWF       optreg          ; Transfer to option register
            BCF         _rp0            ; Select page 0

            MOVLW       RTCC_INIT       ;
            MOVWF       rtcc            ; Initialise RTCC with init value

;           **************** Configure I/O Ports *****************

            MOVLW       11100000B       ;
            MOVWF       porta           ; Initialise port A output register
            BSF         _rp0            ; Select page 1
            MOVLW       11100000B       ;
            MOVWF       trisa           ; Define port A data direction
            BCF         _rp0            ; Select page 0

            MOVLW       00000000B       ;
            MOVWF       portb           ; Initialise port B output register
            BSF         _rp0            ; Select page 1
            MOVLW       00000000B       ;
            MOVWF       trisb           ; Define port B data direction
            BCF         _rp0            ; Select page 0

;           **************** Initialise variables ****************

            CLRF        TIMER1          ; Init software timer 1
            CLRF        TIMER2          ; Init software timer 2
            CLRF        TIMER4          ; Init software timer 4
            CLRF        TIMER5          ; Init software timer 5
            MOVLW       10              ;
            MOVWF       TIMER3          ; Init software timer 3 (10mS)
            MOVWF       TIMER6          ; Init software timer 6 (100mS)
            MOVLW       200             ;
            MOVWF       TIMER7          ; Init software timer 7 (20S)

            CLRF        KEY_VAL         ; Initialise KEY_VAL
            CLRF        KVAL_OLD        ; Initialise KVAL_OLD
            CLRF        KEY_FLGS        ; Initialise KEY_FLGS

            CLRF        COL1            ; Initialise COL1
            CLRF        COL2            ; Initialise COL2
            CLRF        COL3            ; Initialise COL3
            CLRF        COL1_MSK        ; Initialise COL1_MSK
            CLRF        COL2_MSK        ; Initialise COL2_MSK
            CLRF        COL3_MSK        ; Initialise COL3_MSK

;           ***************** Enable interrupts ******************

            BSF         _rtie           ; Enable RTCC overflow interrupt flag
            BSF         _gie            ; Enable interrupts

;           ******************************************************

            RETURN                      ; Return from initialisation subroutine


; ***************************************************************************


Key_Action                              ; Test for key and take appropriate action

            BCF         _gie            ; Disable interrupts
            BTFSS       KEY_FLGS,bit0   ; Test valid key flag
            GOTO        KAct_End        ; If clear goto KAct_End else continue

            MOVLW       200             ;
            MOVWF       TIMER7          ; Load timer 7 with 20S

            DECF        KEY_VAL,w       ; wreg = KEY_VAL - 1
            BSF         _gie            ; Enable interrupts
            ADDLW       3               ; Add fixed offset to w (jump these instructions)
            ADDWF       pcl,w           ; Add table offset to plc (result in w)
            BTFSC       _c              ; Test if carry flag is set
            INCF        pclath,f        ; If set add 1 to PCLATH
            MOVWF       pcl             ; Load program counter (low byte) with jump address
            
            GOTO        Key1            ; If yes goto Key1 else continue
            GOTO        Key2            ; If yes goto Key2 else continue
            GOTO        Key3            ; If yes goto Key3 else continue
            GOTO        Key4            ; If yes goto Key4 else continue
            GOTO        Key5            ; If yes goto Key5 else continue
            GOTO        Key6            ; If yes goto Key6 else continue
            GOTO        Key7            ; If yes goto Key7 else continue
            GOTO        Key8            ; If yes goto Key8 else continue
            GOTO        Key9            ; If yes goto Key9 else continue

;           ******************************************************

Key1                                    ; Key 1 pressed (KEY_VAL = 1)

            BTFSC       COL1,bit0       ; Test if LED 1 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL1,bit1       ; Test if LED 1 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL1,bit0       ; If set enable LED 1 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL1,bit1       ; If set enable LED 1 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

Key2                                    ; Key 2 pressed (KEY_VAL = 2)

            BTFSC       COL2,bit0       ; Test if LED 2 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL2,bit1       ; Test if LED 2 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL2,bit0       ; If set enable LED 2 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL2,bit1       ; If set enable LED 2 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

Key3                                    ; Key 3 pressed (KEY_VAL = 3)

            BTFSC       COL3,bit0       ; Test if LED 3 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL3,bit1       ; Test if LED 3 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL3,bit0       ; If set enable LED 3 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL3,bit1       ; If set enable LED 3 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

Key4                                    ; Key 4 pressed (KEY_VAL = 4)

            BTFSC       COL1,bit2       ; Test if LED 4 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL1,bit3       ; Test if LED 4 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL1,bit2       ; If set enable LED 4 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL1,bit3       ; If set enable LED 4 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

Key5                                    ; Key 5 pressed (KEY_VAL = 5)

            BTFSC       COL2,bit2       ; Test if LED 5 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL2,bit3       ; Test if LED 5 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL2,bit2       ; If set enable LED 5 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL2,bit3       ; If set enable LED 5 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

Key6                                    ; Key 6 pressed (KEY_VAL = 6)

            BTFSC       COL3,bit2       ; Test if LED 6 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL3,bit3       ; Test if LED 6 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL3,bit2       ; If set enable LED 6 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL3,bit3       ; If set enable LED 6 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

Key7                                    ; Key 7 pressed (KEY_VAL = 7)

            BTFSC       COL1,bit4       ; Test if LED 7 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL1,bit5       ; Test if LED 7 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL1,bit4       ; If set enable LED 7 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL1,bit5       ; If set enable LED 7 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

Key8                                    ; Key 8 pressed (KEY_VAL = 8)

            BTFSC       COL2,bit4       ; Test if LED 8 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL2,bit5       ; Test if LED 8 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL2,bit4       ; If set enable LED 8 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL2,bit5       ; If set enable LED 8 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

Key9                                    ; Key 9 pressed (KEY_VAL = 9)

            BTFSC       COL3,bit4       ; Test if LED 9 (red) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End
            BTFSC       COL3,bit5       ; Test if LED 9 (green) is enabled
            GOTO        KAct_End        ; If yes goto KAct_End

            BTFSC       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL3,bit4       ; If set enable LED 9 (red) else continue
            BTFSS       KEY_FLGS,bit1   ; Test colour toggle flag
            BSF         COL3,bit5       ; If set enable LED 9 (green) else continue

            GOTO        KAct_Tog        ;

;           ******************************************************

KAct_Tog    MOVLW       00000010B       ;
            XORWF       KEY_FLGS,f      ; Toggle colour flag


KAct_End    BSF         _gie            ; Enable interrupts
            RETURN                      ; Return from subroutine


; **************************************************************************
; **************************************************************************
            
            
            INCLUDE     "intserv.asm"   ; Interrupt service routines
            INCLUDE     "win_test.asm"  ; Win test routines


; **************************************************************************

            END
