; PICelect230.ASM 21MAY04 - COPYRIGHT JOHN BECKER - EPE PIC ELECTRIC MK2

;PIC16F876, 3.2768MHz, WDT OFF, POR ON, XTAL XS

;PROGRAM WRITTEN IN TASM VARIANT - NEEDS TRANSLATING VIA TK3 TO SUIT MPASM

;Config register bits
; CP1 CP0 CP1 CP0 NIL CPD LVP BOR MCL OS2 POR WDT OS1 OS0
;  1   1   1   1   1   1   0   0   1   0   0   0   0   1
;N.B. Logic 1/0 do NOT necessarily mean that the function is On/Off
;respectively - refer to PIC16F876 data sheet

#DEFINE CHAN0 iorlw B'00000000'

#DEFINE BLOCK0 BCF STATUS,7             ; clear STATUS bit 7 (IRP)
#DEFINE BLOCK1 BSF STATUS,7             ; set   STATUS bit 7 (IRP)
#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5
#DEFINE SERIALDELAY call CYCLES5  ; set serial chip write delay value
                         ; CYCLES25 for 20MHz, CYCLES5 for 4MHz or below

        List P = PIC16F876, R=DEC;
        __CONFIG   h'3F31'

        include P16F876.inc

        CBLOCK

REGA0				;lsb
REGA1
REGA2
REGA3				;msb

REGB0				;lsb
REGB1
REGB2
REGB3				;msb

REGC0                           ;lsb
REGC1
REGC2
REGC3                           ;msb

DSIGN				;Digit Sign. 0=positive,FF(or non zero)=negative
DIGIT1				;MSD
DIGIT2
DIGIT3
DIGIT4
DIGIT5				;Decimal digits
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10				;LSD
MTEMP
MCOUNT
DCOUNT
VALIDITY
ABORT

LOOP        ; loop counter
LOOPA       ; loop counter for LCD
RSLINE      ; LCD command/data flag
CLKCNT      ; pre-counter for seconds
CLKSEC
CLKMIN
CLKHRSLSB
CLKHRSMSB

STORE1      ; general store
MEMHI     
MEMLO     
WADDRL    
WADDRH    
RADDRH    
RADDRL    
POLLCNT     ; serial eeprom use
SLAVE       ; serial eeprom use
TXBUF       ; serial eeprom use
BCOUNT  
COUNT   
DATAI   
DATAO   
EEPROM  
ECHAN
MEMCNT
ECHANTEMP

VOLTSMSB
VOLTSLSB

AMPSMSB
AMPSLSB
AMPS2MSB
AMPS2LSB

WATTSMSB
WATTSNSB
WATTSLSB

VOLTSMULTMSB
VOLTSMULTLSB
AMPSMULTMSB
AMPSMULTLSB
UNITCOSTMSB
UNITCOSTLSB
TOTALCOST1LSB
TOTALCOST1NSB
TOTALCOST1NMSB
TOTALCOST1MSB
TOTALCOST2LSB
TOTALCOST2NSB
TOTALCOST2NMSB
TOTALCOST2MSB
SYNCFLAG
SYNCDELAYMSB
SYNCDELAYLSB
DISPLAYCOUNT
PAGEFLAG
HERTZFLAG
MAINSFREQ
STARTFLAG
HERTZMSB
HERTZLSB
	ENDC

; ***** VALUES HELD IN BOTH BANKS

        CBLOCK H'78'
PROMVAL
MEMFUL
        ENDC

             ;************************************************************
             ;           Bit Definitions
             ;************************************************************

DI:         .EQU $07        ; eeprom input bit
DO:         .EQU $06        ; eeprom output bit
SDATA:      .EQU $04        ; serial EE data line (PORTC)
SCLK:       .EQU $03        ; serial EE clock line (PORTC)

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF

START:  bcf STATUS,RP0
        bcf STATUS,RP1
        clrf PORTA       ; initialise all port outputs to zero
        clrf PORTB
        clrf PORTC

        BANK1
        movlw %11000000
        movwf TRISB
        movlw B'10000100'       ; set RHS justify, RA0, RA1, RA3 as analog inputs
        movwf ADCON1            ; with ref to +VE and 0V
        movlw %00011011         ; RA0, RA1, RA3, RA4 as input
        movwf TRISA
        movlw %10000111         ; RC7, RC2-RC0 as input
        movwf TRISC
        movlw B'00000100'       ; timer 1:64 (1/50th sec), pull-ups off
        movwf OPTION_REG
        BANK0

        movlw %00000000  ; set timer 1 for prescale 1:1 (bits 5 & 4), and timer off (bit 0)
        movwf T1CON

        movlw B'10000001'       ; set AD on, Fosc/32
        CHAN0                   ; set for CHAN0 - RA0
        movwf ADCON0
	  
        clrf PCLATH

        movlw 1
        movwf STARTFLAG

        call SETUP

        btfsc PORTC,0   ; is sample delay change needed?
        call CHANGESYNC

        btfsc PORTC,1   ; is cost change needed?
        call CHANGECOST

        call SHOWTITLE
        call SHOWCOUNT
        movlw 100         ; initial basic CLKCNT val for secs timing
        movwf CLKCNT      ; to give main title chance to be seen
        bcf INTCON,2

;********* START OF MAIN PROGRAM ********

MAIN:   btfss   PIR1,RCIF       ; Check for any RX'd data
        goto MAIN2              ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        sublw   'S'             ; Is this an 'S' for Set ?
        btfss   STATUS,Z
        goto MAIN2              ; no
        bsf PORTA,2             ; yes

MAIN3A: btfss   PIR1,RCIF       ; Check for any RX'd data
        goto MAIN3A             ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        sublw   'G'             ; Is this a 'G' for Go ?
        btfsc   STATUS,Z
        call JOEDOWNLOAD        ; Yes, a 'G'
        bcf PORTA,2

MAIN2:  movf PORTA,W            ; wait for positive-going pulse
        andlw %00010000
        movwf STORE1
        xorwf SYNCFLAG,W
        btfsc STATUS,Z
        goto MAIN
        movf STORE1,W
        movwf SYNCFLAG
        btfss STORE1,4
        goto MAIN

MAIN4:  movf PORTC,W            ; check switch on RC2
        andlw %00000100
        movwf STORE1
        xorwf DISPLAYCOUNT,W
        btfsc STATUS,Z
        goto TIMEIT
        movf STORE1,W
        movwf SYNCFLAG
        movwf DISPLAYCOUNT
        btfsc STORE1,2
        call PAGECHANGE

TIMEIT: decfsz CLKCNT,F         ; decrement system clock counter. Is it = 0?
        goto MAIN                 

SYNCIT: call SYNCDELAY
        call GETADCAMPS         ; AMPS
        call SYNCDELAY
        call GETADCVOLTS        ; VOLTS
        call LCD13              ; screen 1 line
        call CALCVOLTS

        movlw AMPSMSB           ; channel 1
        movwf FSR
        call LCD1               ; screen 1 line 1
        call CALCAMPS
        movlw AMPSMSB           ; channel 1
        movwf FSR

        call CALCWATTS
        movlw TOTALCOST1LSB
        movwf FSR
        call LCD16              ; screen 2 line 1
        call GETCOST

        movlw AMPS2MSB          ; channel 2
        movwf FSR
        call LCD21              ; screen 2 line 1
        call CALCAMPS
        movlw AMPS2MSB          ; channel 2
        movwf FSR
        call CALCWATTS
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'V'
        call LCDOUT

        call SECCLK             ; inc clock, also store data every 10 mins
        movlw TOTALCOST2LSB
        movwf FSR
        call LCD216             ; screen 2 line 2
        call GETCOST
        call SHOWCLOCK

        movf MEMFUL,W     ; is ECHAN now equal to MEMCNT? (MEMFUL = 1)
        btfss STATUS,Z
        clrf ECHAN
        movf MAINSFREQ,W    ; reset start value of CLKCNT (50Hz or 60Hz)
        movwf CLKCNT
        goto MAIN

;********** LCD CONTROL SECTION *********

LCD1:   movlw %10000000
        goto LCDLIN
LCD10:  movlw %10001010
        goto LCDLIN
LCD13:  movlw %10001101
        goto LCDLIN
LCD16:  movlw %10010000
        goto LCDLIN
LCD17:  movlw %10011000
        goto LCDLIN
LCD21:  movlw %11000000
        goto LCDLIN
LCD2F:  movlw %11001111
        goto LCDLIN
LCD216: movlw %11010000
        goto LCDLIN

LCDOUT: movwf STORE1    ; temp store value that will be output to LCD
        movlw 60        ; set minimum time between sending full bytes to LCD
        movwf LOOPA
DELAY:  decfsz LOOPA,F
        goto DELAY
        call SENDIT     ; send MSB, then (by default) send LSB

SENDIT: swapf STORE1,F  ; swap byte nibbles
        movf STORE1,W   ; get nibble (MSB)
        andlw 15        ; AND to isolate nibble
        iorwf RSLINE,W  ; OR the RS bit
        movwf PORTB     ; output the byte
        nop
        bsf PORTB,5     ; set E high
        nop
        bcf PORTB,5     ; set E low
        return

LCDLIN: bcf RSLINE,4    ; sets LCD command/line
        call LCDOUT     ; and outputs cmmand code to LCD
        bsf RSLINE,4    ; set RS flag
        return

PAUSIT: movlw 14        ; wait set
        movwf CLKCNT
        clrf INTCON     ; clear interupt flag
PAUSE:                  ;
        btfss INTCON,2  ; has a timer time-out been detected?
        goto PAUSE      ; no
        bcf INTCON,2    ; yes
        decfsz CLKCNT,F ; dec loop, is it zero?
        goto PAUSE      ; no
        return          ; yes

; **************

CLEARIT: call CLRLINE1        ; clear entire external serial eeprom
        call CLRLINE2

        clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWCLR: movf LOOP,W
        bsf PCLATH,3
        call MESSAG2          ; clearing eeprom
        clrf PCLATH
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCLR

        clrf LOOP
        call LCD21
        bsf RSLINE,4
SHOWCL2: movf LOOP,W
        bsf PCLATH,3
        call MESSAG3          ; clearing eeprom
        clrf PCLATH
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWCL2
        call LCD2F
        incf ECHAN,W
        iorlw 48
        call LCDOUT
        call CLEARADR

CLEAR2: clrf MEMHI
        clrf MEMLO
        call SAVESAMPLE
        btfsc MEMFUL,0    ; is MEMFUL set from address inc routine?
        goto CLEAR4       ; yes
        btfss STATUS,C    ; is there a carry from address inc routine?
        goto CLEAR2       ; no

        movf WADDRL,W     ; yes, so show count
        movwf REGA0
        movf WADDRH,W
        movwf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call LCD21
        bsf RSLINE,4
        call SHOWDIG5     ; show current record count
        goto CLEAR2

CLEAR4: call CLEARADR
        call STORECOUNT  ; store reset count value to eeprom
        call CLRLINE1
        call CLRLINE2
        call SHOWTITLE
        return

; **********

SHOWTITLE: clrf LOOP
        call LCD1
        bsf RSLINE,4
SHOWMS1: movf LOOP,W
        bsf PCLATH,3
        call MESSAG1
        clrf PCLATH
        call LCDOUT
        incf LOOP,F
        btfss LOOP,4
        goto SHOWMS1
        return

; *********

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

; ***************

STOREIT: clrf MEMHI         ; write 2 zeros to maintain even 8 bytes per sample cycle
         movf STARTFLAG,W   ; but a 1 is written if program has just started to indicate
         movwf MEMLO        ; where data breaks occur
         call SAVESAMPLE
         clrf STARTFLAG

         movf VOLTSMSB,W    ; store volts to external serial EEPROM chip
         movwf MEMHI
         movf VOLTSLSB,W
         movwf MEMLO
         call SAVESAMPLE
         movf AMPSMSB,W    ; store amps chan 1 to external serial EEPROM chip
         movwf MEMHI
         movf AMPSLSB,W
         movwf MEMLO
         call SAVESAMPLE
         movf AMPS2MSB,W    ; store amps chan 2 to external serial EEPROM chip
         movwf MEMHI
         movf AMPS2LSB,W
         movwf MEMLO
         call SAVESAMPLE
         return

;*********

;SERIALMEM01 30MAR02 from LOG430.ASM 29OCT99 - JOHN BECKER - EPE DATA LOGGER MODIFIED EXTRACT
; MODIFIED FOR PORTA

SAVESAMPLE:  movf MEMHI,W   ; store MSB
        call WRBYTE
        incf WADDRL,F      ; inc address
        movf MEMLO,W       ; store LSB
        call WRBYTE
        decf WADDRL,F      ; dec address back to prev count
        call INCADDRESS
        return

;*********** cycles pause called by Serial EEPROM write routines ****

; the CALL takes 2 clock cycles
; the RETURN takes 2 clock cycles
; a pause of 4 clock cycles is created by just CALLing CYCLES4 and returning
; each NOP adds a further 1 cycle pause

CYCLES5:   NOP
CYCLES4:   return

;*************


;CONVERTED MPASM FILE C:\ASMCNV\2WDPOLL.ASM
;       TO TASM  FILE C:\PIC\2WDPOLL.ASM 03-12-1999 19:28:42
; see Microchip CD-ROM disk 2, download\appnote\category\eeproms\00567.ZIP
; the original used timings based on a 4MHz clock
; this routine has been modified to enable different xtal rates
; Defining SERIALDELAY as "call CYCLE5" is for 4MHz or less xtal
; Defining SERIALDELAY as "call CYCLE25" is for 20MHz xtal

          ;***************************************************************
          ;       Byte Write Routine with data polling
          ;***************************************************************

WRBYTE:   movwf DATAO         ;entry with val to send in W, stored to DATAO
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode
          MOVWF SLAVE

BYTE:     CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; move slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          movf WADDRL,W       ; send address low byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it

          MOVF DATAO,W        ; move data byte
          MOVWF TXBUF         ; to tranmit buffer
          CALL TX             ; and transmit it
          CALL BSTOP          ; generate stop bit

          MOVLW 40            ; now start polling for a low ack bit
          MOVWF POLLCNT       ; set max number of times to poll
POLL:     CALL BSTART         ; generate start bit

          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000   ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX             ; and send it
          BTFSS EEPROM,DI     ; was the ack bit low?
          GOTO EXITPOLL       ; yes, do another byte
          DECFSZ POLLCNT,F    ; is poll counter down to zero?
          GOTO POLL           ; no, poll again.
EXITPOLL: return

          ;**************************************************************
          ;       Start Bit Subroutine - generates a start bit
          ;       (Low going data line while clock is high)
          ;**************************************************************

BSTART:   BSF PORTC,SDATA    ; make sure data is high
          BANK1
          MOVLW %10000111
          MOVWF TRISC        ; set data and clock lines for output
          BANK0
          BCF PORTC,SCLK     ; make sure clock is low
          NOP                 
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SDATA    ; data line goes low during
                             ; high clock for start bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; start clock train
          NOP                 
          NOP                 
          RETLW 0             

          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP:    BANK1
          MOVLW %10000111
          MOVWF TRISC        ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA    ; make sure data line is low
          SERIALDELAY        ; timing adjustment        
          BSF PORTC,SCLK     ; set clock high
          SERIALDELAY        ; timing adjustment
          BSF PORTC,SDATA    ; data goes high while clock high for stop bit
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; set clock low again
          SERIALDELAY        ; timing adjustment
          RETLW 0

            ;*************************************************************
            ;       BITOUT routine takes one bit of data in 'do' and
            ;       transmits it to the serial EE device
            ;*************************************************************

BITOUT:   BANK1
          MOVLW %10000111
          MOVWF TRISC
          BANK0
          BTFSS EEPROM,DO    ; check for state of data bit to xmit
          GOTO BITLOW        ;
          BSF PORTC,SDATA    ; set data line high
          GOTO CLKOUT        ; go toggle the clock

BITLOW:   BCF PORTC,SDATA    ; output a low bit
CLKOUT:   BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BCF PORTC,SCLK     ; return clock line low
          RETLW 0             

          ;**************************************************************
          ;       BITIN routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN:    BSF EEPROM,DI       ; assume input bit is high
          BANK1
          MOVLW %10010111     ; make sdata an input line
          MOVWF TRISC
          BANK0
          BSF PORTC,SDATA    ; set sdata line for input
          BSF PORTC,SCLK     ; set clock line high
          SERIALDELAY        ; timing adjustment
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI      ; input bit was low
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX:       MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP:     BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; otherwise data bit =1
          CALL BITOUT         ; serial data out
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP           ; no - go again
          CALL BITIN          ; read ack bit
          RETLW 0             

                              
;CONVERTED MPASM FILE C:\ASMCNV\2WSEQR.ASM
;       TO TASM  FILE C:\PIC\2WSEQR.ASM 03-12-1999 19:29:04

          ;************************************************************
          ;       2-Wire Sequential Read Program
          ;************************************************************
          ;       Stop Bit Subroutine - generates a stop bit
          ;       (High going data line while clock is high)
          ;************************************************************

BSTOP2:   BANK1
          MOVLW %10000111     ;
          MOVWF TRISC         ; set data/clock lines as outputs
          BANK0
          BCF PORTC,SDATA     ; make sure data line is low
          SERIALDELAY
          BSF PORTC,SCLK      ; set clock high
          SERIALDELAY
          BSF PORTC,SDATA     ; data goes high while clock high for stop bit
          SERIALDELAY
          BCF PORTC,SCLK      ; set clock low again
          SERIALDELAY
          RETLW 0

          ;**************************************************************
          ;       BITIN2 routine reads one bit of data from the
          ;       serial EE device and stores it in 'di'
          ;**************************************************************

BITIN2:   BSF EEPROM,DI       ; assume input bit is high
          BANK1
          MOVLW %10010111     ; make sdata an input line
          MOVWF TRISC
          BANK0
          BSF PORTC,SCLK      ; set clock line high
          SERIALDELAY
          BTFSS PORTC,SDATA  ; read the data bit
          BCF EEPROM,DI       ; input bit was low, set 'di' accordingly
          BCF PORTC,SCLK     ; set clock line low
          RETLW 0             

          ;****************************************************************
          ;       Transmit Data Subroutine
          ;****************************************************************

TX2:      MOVLW 8
          MOVWF COUNT         ; set the #bits to 8
TXLP2:    BCF EEPROM,DO       ; assume bit out is low
          BTFSC TXBUF,7       ; is bit out really low?
          BSF EEPROM,DO       ; no, set it high
          CALL BITOUT         ; send the bit to serial EE
          RLF TXBUF,F         ; rotate txbuf left
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO TXLP2          ; no - go again
          CALL BITIN2         ; read ack bit
          BTFSC EEPROM,DI     ; check ack bit
          NOP
          RETLW 0             

          ;****************************************************************
          ;       Receive data Routine
          ;****************************************************************

RX:       MOVLW 8             ; set # bits to 8
          MOVWF COUNT         
          CLRF DATAI          ; clear input register
          BCF STATUS,0        ; make sure carry bit is low
RXLP:     RLF DATAI,F         ; rotate DATAI 1 bit left
          CALL BITIN2         ; read a bit
          BTFSC EEPROM,DI     
          BSF DATAI,0         ; set bit 0 if necessary
          DECFSZ COUNT,F      ; 8 bits done?
          GOTO RXLP           ; no, do another
          RETLW 0             

          ;**************************************************************
          ;       READ (sequential read routine)
          ;**************************************************************

READ:     MOVLW 2             
          MOVWF BCOUNT        ; set number of bytes to read
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100000     ; set slave address and write mode
          MOVWF SLAVE         

          CALL BSTART         ; generate start bit
          MOVF SLAVE,W        ; get slave address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          movf RADDRH,W       ; send address high byte
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          MOVF RADDRL,W       ; get word address
          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and send it

          CALL BSTART         ; generate start bit
          bcf STATUS,C
          rlf ECHAN,W
          iorlw %10100001     ; set slave address and write mode

          MOVWF TXBUF         ; into transmit buffer
          CALL TX2            ; and transmit it
                              ;
RBYTE:    CALL RX             ; read 1 byte from device
          DECFSZ BCOUNT,F     ; are both bytes read?
          GOTO LOWACK         ; no, send low ack and do another
          BSF EEPROM,DO       ; yes, send high ack bit
          CALL BITOUT         ; to stop transmission
          CALL BSTOP2         ; and send a stop bit
          movf DATAI,W
          movwf MEMLO         ;data low byte
          return

LOWACK:   movf DATAI,W
          movwf MEMHI         ; data high byte
          BCF EEPROM,DO       ; send low ack bit
          CALL BITOUT         ; to continue transmission
          GOTO RBYTE          ; and read another byte

;**************

JOEDOWNLOAD: movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movwf T1CON
        clrf TMR1L       ; reset timer 1
        clrf TMR1H

;        btfsc PAGEFLAG,0
        call BACKIT
        clrf PAGEFLAG

        bcf PIR1,0       ; timer rollover flag
        bsf T1CON,0      ; start timer 1
        call CLRLINE2     ; clear LCD line 2

         clrf LOOP
         call LCD1
         bsf RSLINE,4
SHOWMSGJ movf LOOP,W
         bsf PCLATH,3
         call MESSAG4      ; sending to PC message
         clrf PCLATH
         call LCDOUT
         incf LOOP,F
         btfss LOOP,4
         goto SHOWMSGJ

         call JOESENDPC    ; send chips to PC

LS2:     call SHOWTITLE

;        movlw %00110000  ; set timer 1 for prescale 1/8, and timer off
        movlw %00000000  ; restore timer 1 to main val
        movwf T1CON

         movf MAINSFREQ,W ; reset clk counter
         movwf CLKCNT
         return 

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03
;---------------------------------------------------------------------
; Description:
; Sends 100 blocks of 258 bytes (256 data + 2 trailer) to the
; serial port.
; On receipt of a 'G' command from the PC, the PIC waits for 'B'
; command and then sends a 258 byte block. The PIC again waits for a 'B'
; command before sending the next block.
; The block being sent is reflected on the PORTB LEDS.
; Each block contains ASCII codes (0 to 255).
;
; The PIC waits for a character before sending back the ASCII block
;
;---------------------------------------------------------------------

JOESETBAUD
        BANK1                   ; Configure the baud rate generator
;        movlw 129               ; BRG for 9600baud from 20MHz, brgh=1
;        movlw 64                ; 4800 Baud with 20MHz XTAL (See PIC data sheet for these values)
;        movlw 42                ; 4800 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
;        movlw 47                ; 4800 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
;        movlw 23                ; 9600 Baud with 3.6864MHz XTAL (See PIC data sheet for these values)
        movlw 20                ; 9600 Baud with 3.2768MHz XTAL (See PIC data sheet for these values)
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 4)
        movwf   TXSTA           ; In bank 1
        bcf     STATUS,RP0      ; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; ***********

COPY_REGA_REGB:
        movf REGA0,W    
        movwf REGB0
        movf REGA1,W
        movwf REGB1
        movf REGA2,W
        movwf REGB2
        movf REGA3,W
        movwf REGB3
        return

; ***********

SHOWDIG1: movf DIGIT1,W
          call LCDOUT
SHOWDIG2: movf DIGIT2,W
          call LCDOUT
SHOWDIG3: movf DIGIT3,W
          call LCDOUT
SHOWDIG4: movf DIGIT4,W
          call LCDOUT
SHOWDIG5: movf DIGIT5,W
          call LCDOUT
SHOWDIG6: movf DIGIT6,W
          call LCDOUT
SHOWDIG7: movf DIGIT7,W
          call LCDOUT
SHOWDIG8: movf DIGIT8,W
          call LCDOUT
SHOWDIG9: movf DIGIT9,W
          call LCDOUT
SHOWDIG10: movf DIGIT10,W
          call LCDOUT
        return

; ************

INCADDRESS: clrf MEMFUL
         movlw 2
         addwf WADDRL,F    ;inc write address by 2
         btfss STATUS,C
         return 
         incf WADDRH,F
         btfss WADDRH,7    ; is bit 7 of MSB now set?
         return            ; no
         bsf MEMFUL,0
         return

; *****************

CLEARADR: clrf MEMHI
        clrf MEMLO
        clrf WADDRH      ; set write address MSB
        clrf WADDRL      ; set write address LSB
        clrf RADDRH      ; set read address MSB
        clrf RADDRL      ; set read address LSB
        clrf ECHAN
        clrf MEMFUL
        return

; ****** GET SERIAL EEPROM CHIP COUNT

CHIPCOUNT: clrf ECHAN

GETCHIP  clrf WADDRH      ; set write address MSB
         clrf WADDRL      ; set write address LSB
         clrf RADDRH      ; set read address MSB
         clrf RADDRL      ; set read address LSB

         call READ        ; read from EEPROM chip
         movf MEMLO,W     ; get LSB value
         movwf VALIDITY

         comf MEMLO,F     ; invert value
         clrf WADDRL      ; set write address LSB
         call SAVESAMPLE

         clrf RADDRL      ; set read address LSB
         call READ        ; read from EEPROM chip
         xorwf VALIDITY,W ; is 2nd read value same as 1st read?
         btfsc STATUS,Z
         goto STORECHIPS   ; yes

WRITEBACK comf MEMLO,F
         clrf WADDRL      ; set write address LSB
         call SAVESAMPLE
         clrf RADDRL      ; set write address LSB

         call READ        ; read from EEPROM chip
         incf ECHAN,F
         btfss ECHAN,3
         goto GETCHIP

STORECHIPS: movf ECHAN,W
        movwf MEMCNT
        clrf ECHAN
        clrf WADDRH
        clrf WADDRL

SHOWCHIPS: call LCD21
         bsf RSLINE,4

         movf MEMCNT,W
         iorlw 48
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'E'
         call LCDOUT
         movlw 'P'
         call LCDOUT
         movlw 'R'
         call LCDOUT
         movlw 'O'
         call LCDOUT
         movlw 'M'
         call LCDOUT
         movlw ' '
         call LCDOUT
         movlw 'C'
         call LCDOUT
         movlw 'H'
         call LCDOUT
         movlw 'I'
         call LCDOUT
         movlw 'P'
         call LCDOUT
         return

; *********** READ ADC CHANNEL *****

GETADCVOLTS:    bcf ADCON0,3            ; set ADC Chan 0
                call DELAYB
                bsf PORTC,5
                bsf ADCON0,GO           ; start data conversion
                nop
GETADC2:        btfsc ADCON0,GO
                goto GETADC2
                movf ADRESH,W           ; get ADC MSB val
                movwf VOLTSMSB          ; store it 
                BANK1
                movf ADRESL,W           ; get ADC LSB val
                BANK0
                movwf VOLTSLSB          ; store it
                bcf PORTC,5
                return

; *************** GET AMPS **********

GETADCAMPS:     bsf ADCON0,3            ; set ADC Chan 1
                call SETTIMER1
                bsf PORTC,5
                bsf ADCON0,GO           ; start data conversion
                nop
GETADC3:        btfsc ADCON0,GO         ; channel 1 upper level
                goto GETADC3
                movf ADRESH,W           ; get ADC MSB val
                movwf AMPSMSB           ; store it
                BANK1
                movf ADRESL,W           
                BANK0
                movwf AMPSLSB           ; store it 

ADC5:           btfss PIR1,0     ; has a timer time-out been detected?
                goto ADC5       ; no
                call SETTIMER1
                bcf PORTC,5

                bsf ADCON0,GO           ; start data conversion
                nop
GETADC6:        btfsc ADCON0,GO         ; channel 1 lower level
                goto GETADC6
                movf ADRESH,W           ; get ADC MSB val
                movwf REGA1             ; store it
                BANK1
                movf ADRESL,W           
                BANK0
                movwf REGA0             ; store it 

                movf REGA0,W
                subwf AMPSLSB,F
                btfss STATUS,C
                incf REGA1,F
                movf REGA1,W
                subwf AMPSMSB,F
                btfsc STATUS,C
                goto GETADC4
                comf AMPSLSB,F           ; negate
                comf AMPSMSB,F
                incfsz AMPSLSB,F
                goto GETADC4
                incf AMPSMSB,F

GETADC4:  ;      bcf STATUS,C    ; divide by 2 to compensate for x2 opamp
          ;      rrf AMPSMSB,F
          ;      rrf AMPSLSB,F

GETADCAMPS2:    bsf ADCON0,4            ; set ADC Chan 3
ADC21:          btfss PIR1,0     ; has a timer time-out been detected?
                goto ADC21      ; no
                bsf PORTC,5
                call SETTIMER1

                bsf ADCON0,GO           ; start data conversion
                nop
GETADC23:       btfsc ADCON0,GO         ; channel 2 upper level
                goto GETADC23
                movf ADRESH,W           ; get ADC MSB val
                movwf AMPS2MSB           ; store it
                BANK1
                movf ADRESL,W           
                BANK0
                movwf AMPS2LSB           ; store it 

ADC25:          btfss PIR1,0     ; has a timer time-out been detected?
                goto ADC25       ; no
                bcf PORTC,5
                call SETTIMER1

                bsf ADCON0,GO           ; start data conversion
                nop
GETADC26:       btfsc ADCON0,GO         ; channel 2 lower level
                goto GETADC26
                movf ADRESH,W           ; get ADC MSB val
                movwf REGA1             ; store it
                BANK1
                movf ADRESL,W           
                BANK0
                movwf REGA0             ; store it 

                movf REGA0,W
                subwf AMPS2LSB,F
                btfss STATUS,C
                incf REGA1,F
                movf REGA1,W
                subwf AMPS2MSB,F
                btfsc STATUS,C
                goto GETADC24
                comf AMPS2LSB,F
                comf AMPS2MSB,F
                incfsz AMPS2LSB,F
                goto GETADC24
                incf AMPS2MSB,F

GETADC24:  ;     bcf STATUS,C    ; divide by 2 to compensate for x2 opamp
           ;     rrf AMPS2MSB,F
           ;     rrf AMPS2LSB,F

                bcf ADCON0,4            ; set ADC Chan 0
                bcf ADCON0,3            ; set ADC Chan 0
                return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        MOVF PROMVAL,W  ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

; ***********

STORECOUNT: movf WADDRH,W           ; set recording count into EEPROM
        movwf PROMVAL
        movlw 8
        call SETPRM

        movf WADDRL,W
        movwf PROMVAL
        movlw 9
        call SETPRM
        return

; ***************

JOESENDPC
        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL

; 'G' has been received - Confirm ready state back to PC

        movlw   'P'
        call    TxByte
        movlw   'I'
        call    TxByte
        movlw   'C'
        call    TxByte
        movlw   'e'
        call    TxByte
        movlw   'l'
        call    TxByte
        movlw   'e'
        call    TxByte
        movlw   'c'
        call    TxByte
        movf MEMCNT,W            ; number of EEPROM chips
        iorlw 48
        call    TxByte
        movlw 1
        call TxByte
        movlw 0        
        call    TxByte
        movf WADDRH,W            ; send current WRITE address
        call    TxByte
        movf WADDRL,W
        call    TxByte
        movf UNITCOSTMSB,W
        call    TxByte
        movf UNITCOSTLSB,W
        call    TxByte

        movf MEMCNT,W
        btfsc STATUS,Z           ; are there any eeprom chips installed?
        return                   ; no

BYPASS: movf ECHAN,W             ; temp store ECHAN
        movwf ECHANTEMP
        clrf ECHAN

        goto WAITB

WaitG 				; Wait for any character to be received
        call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        sublw   'G'             ; Is this a 'G'
        btfss   STATUS,Z
        goto    WaitG           ; Not a 'G'

; 'G' has been received - Confirm ready state back to PC
SendR:  movlw   'R'             ; Signal 'R'eady
        call    TxByte

; Start sending the blocks
; First, wait for the PC to send us a 'B' command (Send block)

WaitB
	call 	FlushRXBuffer   ; Make sure that the RX buffer is empty
        call    RecLoop         ; Wait and read from serial - character returned in W
        movwf   PORTB
        sublw   'B'             ; Is this a 'B'
        btfsc   STATUS,Z
        goto    SendNext        ; Yes a 'B'
        btfsc ABORT,0           ; is abort tranfser flag set?
        goto    ENDTF           ; yes, so abort transfer
        goto    WaitB           ; Not a 'B'

; 'B' received, send a block

SendNext
         call READ         ; read from EEPROM chip
         movf MEMLO,W      ; get LSB value
         call TXBYTE       ; send it to PC
         movf MEMHI,W      ; get MSB value
         call TXBYTE       ; send it to PC
       
         movlw 2
         addwf RADDRL,F    ; inc read address by 2
         btfss STATUS,C
         goto SendNext

; Data portion of the block has been sent, now send the Block terminator
        movlw   0x0D            ; CR
        call    TxByte
        movlw   0x0A            ; LF
        call    TxByte

        incf RADDRH,F
        btfss RADDRH,7    ; is bit 7 of MSB high? (32768)
        goto    WaitB

        clrf RADDRH       ; reset start address for reading EEPROM chip
        clrf RADDRL

        incf ECHAN,F
        movf ECHAN,W
        xorwf MEMCNT,W
        btfss STATUS,Z
        goto WAITB

ENDTF:  movf ECHANTEMP,W   ; restore count into ECHAN
        movwf ECHAN
        return

; Receive a character from RS232
; (This routine does not return until a character has been received)
; The received character is in the W register

RecLoop:
        clrf TMR1L            ; reset timer 1
        clrf TMR1H
        bcf PIR1,0            ; clear timer 1 overflow

RecLoop2:
        btfss PIR1,0          ; has timer 1 overflowed?
        goto RECLOOP3         ; no
        movlw 0
        bsf ABORT,0           ; yes, set flag
        return

RECLOOP3: nop
        btfss   PIR1,RCIF       ; Check for any RX'd data
        goto    RecLoop2        ; Nothing RX'd
        movf    RCREG,W         ; Store the RX'd data in 'W'
        return

; Send byte in W to the USART

TxByte: nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

DELAYB: nop
        nop
        nop
        nop
        nop
        nop
        nop

        nop
        nop
        nop

        return

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by chksgna, multiply, divide, mod, bin2dec, dec2bin

NEGATEA: movf    REGA3,w         ;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
        incfsz  REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return


;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

;Check sign of REGB and negative convert to positive
;Used by multiply, divide, mod

chksgnb	rlf	REGB3,w
	skpc
	return			;Positive

;Negate REGB
;Used by chksgnb, subtract, multiply, divide, mod

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return


;Add REGB to REGA (Unsigned)
;Used by add, multiply,

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incfsz	REGB3,w
	addwf	REGA3,f
	return

;*** SIGNED SUBTRACT ***
;REGA - REGB -> REGA   ;Return carry set if overflow

subtract:
        call    negateb         ;Negate and add
	skpnc
	return			;Overflow

;*** SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add:    movf    REGA3,w         ;Compare signs
	xorwf	REGB3,w
	movwf	MTEMP

	call	addba		;Add REGB to REGA

	clrc			;Check signs
	movf	REGB3,w		;If signs are same
	xorwf	REGA3,w		;so must result sign
	btfss	MTEMP,7		;else overflow
	addlw	0x80
	return

;*** SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide32: movf  REGB0,w         ;Trap division by zero
	iorwf	REGB1,w
	iorwf	REGB2,w
	iorwf	REGB3,w
	sublw	0
	skpnc
	return

	clrf	MTEMP
	call	chksgna		;Make dividend (REGA) positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

	clrf	REGC0		;Clear remainder
	clrf	REGC1
	clrf	REGC2
	clrf	REGC3

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

	movf	REGB3,w		;Test if remainder (REGC) >= divisor (REGB)
	subwf	REGC3,w
	skpz
	goto	dtstgt
	movf	REGB2,w
	subwf	REGC2,w
	skpz
	goto	dtstgt
	movf	REGB1,w
	subwf	REGC1,w
	skpz
	goto	dtstgt
	movf	REGB0,w
	subwf	REGC0,w
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

	movf	REGB0,w		;Subtract divisor (REGB) from remainder (REGC)
	subwf	REGC0,f
	movf	REGB1,w
	skpc
	incfsz	REGB1,w
	subwf	REGC1,f
	movf	REGB2,w
	skpc
	incfsz	REGB2,w
	subwf	REGC2,f
	movf	REGB3,w
	skpc
	incfsz	REGB3,w
	subwf	REGC3,f
	clrc
	bsf	REGA0,0		;Set quotient bit

dremlt	decfsz	MCOUNT,f	;Next
	goto	dvloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

; *********

CALCVOLTS: movf VOLTSMSB,W
        movwf REGA1
        movf VOLTSLSB,W
        movwf REGA0
        clrf REGA2
        clrf REGA3
        movlw $03            ; multiply by 1000
        movwf REGB1
        movlw $EB
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call MULTIPLY

        movf VOLTSMULTMSB,W  ; divide to get Vac per ADC unit
        movwf REGB1
        movf VOLTSMULTLSB,W
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call DIVIDE32

        movf REGA0,W
        movwf VOLTSLSB
        movf REGA1,W
        movwf VOLTSMSB

        call BIN2DEC
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        return

CALCAMPS: movf INDF,W          ; get amps MSB (chan 1 or chan 2)
        movwf REGA1
        incf FSR,F
        movf INDF,W            ; get amps LSB (chan 1 or chan 2)
        movwf REGA0

        clrf REGA2
        clrf REGA3

        movlw $27              ; multiply by 10000
        movwf REGB1
        movlw $10
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call MULTIPLY

        movf AMPSMULTMSB,W   ; divide to get Iac per ADC unit
        movwf REGB1
        movf AMPSMULTLSB,W
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call DIVIDE32
        movf REGA0,W
        movwf INDF            ; store LSB
        decf FSR,F            ; set FSR back to MSB address
        movf REGA1,W
        movwf INDF            ; store MSB

        call BIN2DEC          ; show on the line selected at call
        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT9,W
        iorlw 48
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

CALCWATTS: movf VOLTSLSB,W     ; multiply volts x amps
        movwf REGA0
        movf VOLTSMSB,W
        movwf REGA1
        clrf REGA2
        clrf REGA3
        movf INDF,W            ; get amps MSB (chan 1 or chan 2)
        movwf REGB1
        incf FSR,F
        movf INDF,W            ; get amps LSB (chan 1 or chan 2)
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call MULTIPLY
        movlw 10             ; divide by 10
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call DIVIDE32
        movf REGA0,W
        movwf WATTSLSB
        movf REGA1,W
        movwf WATTSNSB
        movf REGA2,W
        movwf WATTSMSB

        call BIN2DEC
        movf DIGIT6,W
        call LCDOUT
        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        iorlw 48
        call LCDOUT
        movlw 'W'
        call LCDOUT
        return

GETCOST: movf WATTSLSB,W
        movwf REGA0
        movf WATTSNSB,W
        movwf REGA1
        movf WATTSMSB,W
        movwf REGA2
        clrf REGA3
        movf UNITCOSTMSB,W    ; price is an integer (100 x actual)
        movwf REGB1
        movf UNITCOSTLSB,W
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call MULTIPLY

        movlw $0E             ; divide by 3600 (seconds)
        movwf REGB1
        movlw $10
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call DIVIDE32

        movf INDF,W              ; TOTALCOST LSB
        movwf REGB0
        incf FSR,F
        movf INDF,W              ; TOTALCOST NSB
        movwf REGB1
        incf FSR,F
        movf INDF,W              ; TOTALCOST NMSB
        movwf REGB2
        incf FSR,F
        movf INDF,W              ; TOTALCOST MSB
        movwf REGB3
        call ADD
        movf REGA3,W
        movwf INDF               ; TOTALCOST MSB
        decf FSR,F
        movf REGA2,W
        movwf INDF               ; TOTALCOST NMSB
        decf FSR,F
        movf REGA1,W
        movwf INDF               ; TOTALCOST NSB
        decf FSR,F
        movf REGA0,W
        movwf INDF               ; TOTALCOST LSB


        movlw $03             ; divide by 1000 (kilowatts)
        movwf REGB1
        movlw $E8
        movwf REGB0
        clrf REGB2
        clrf REGB3
        call DIVIDE32

        movlw 100       ; divide by 100 to compensate for price x100
        movwf REGB0
        clrf REGB1
        clrf REGB2
        clrf REGB3
        call DIVIDE32

        call BIN2DEC
        movf DIGIT5,W
        call LCDOUT

        movf DIGIT6,W
        call LCDOUT
        movf DIGIT7,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT8,W
        iorlw 48
        call LCDOUT
        movf DIGIT9,W
        iorlw 48
        call LCDOUT
        return

; **********

SECCLK:         incf CLKSEC,F           ; inc secs in BCD
                movlw 6                 ; check units >9
                addwf CLKSEC,W          ; if 6 is added is there a digit carry?
                btfss STATUS,DC
                return                  ; no
                movwf CLKSEC            ; yes
                xorlw B'01100000'       ; XOR W with 96 (BCD 60)
                btfss STATUS,Z          ; is the answer = 0 (secs = 60)?
                return                  ; no
                clrf CLKSEC             ; yes, clear secs counter
                 
MINCLK:         call STOREIT            ; data stored every 1 min
                call STORECOUNT         ; & recording count
                call SHOWCOUNT
                incf CLKMIN,F           ; inc mins in BCD
                movlw 6                 ; check units >9
                addwf CLKMIN,W          ; if 6 is added is there a digit carry?
                btfss STATUS,DC
                return                  ; no
                movwf CLKMIN            ; yes
                xorlw 96                ; XOR W with 96 (BCD 60)
                btfss STATUS,Z          ; is the answer = 0 (mins = 60)?
                return
                clrf CLKMIN             ; yes, clear mins counter

HRSCLK:         incfsz CLKHRSLSB,F      ; inc hrs in binary
                return
                incf CLKHRSMSB,F
                return

SHOWCLOCK:      movf CLKHRSLSB,W
                movwf REGA0
                movf CLKHRSMSB,W
                movwf REGA1
                clrf REGA2
                clrf REGA3
                call BIN2DEC
                call SHOWDIG7
                movlw ':'
                call LCDOUT
                swapf CLKMIN,W
                andlw %00001111
                iorlw 48
                call LCDOUT
                movf CLKMIN,W
                andlw %00001111
                iorlw 48
                call LCDOUT
                movlw '.'
                call LCDOUT
                swapf CLKSEC,W
                andlw %00001111
                iorlw 48
                call LCDOUT
                movf CLKSEC,W
                andlw %00001111
                iorlw 48
                call LCDOUT
                return

SYNCDELAY: movf SYNCDELAYLSB,W
        movwf REGA0
        movf SYNCDELAYMSB,W
        movwf REGA1
SYNC2:  decfsz REGA0,F
        goto SYNC2
        decfsz REGA1,F
        goto SYNC2
        return

CHANGESYNC:
        call CLRLINE1
        call CLRLINE2

        call LCD21
        movlw 'C'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'G'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'S'
        call LCDOUT
        movlw 'Y'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'C'
        call LCDOUT

CS1:    btfsc PORTC,0
        goto CS1
        call PAUSIT

CS2:    movf PORTA,W
        andlw %00010000
        movwf STORE1
        xorwf SYNCFLAG,W
        btfsc STATUS,Z
        goto CS2 
        movf STORE1,W
        movwf SYNCFLAG
        btfss STORE1,4
        goto CS2

        call SYNCDELAY
        call GETADCAMPS
        movlw AMPSMSB           ; channel 1
        movwf FSR
        call LCD1
        call CALCAMPS
        bcf PORTC,5
    call PAUSIT

CHECKC0: btfss PORTC,0
         goto CHECKC1
         movlw 1
         addwf SYNCDELAYLSB,F
         btfsc STATUS,C
         incf SYNCDELAYMSB,F
         goto CS2

CHECKC1: btfss PORTC,1
         goto CHECKC2
         decfsz SYNCDELAYLSB,F
         goto CS2
         decfsz SYNCDELAYMSB,F
         goto CS2
         incf SYNCDELAYMSB,F
         incf SYNCDELAYLSB,F

CHECKC2: btfss PORTC,2
        goto CS2

CHANGEVOLTS:
        call CLRLINE1
        call CLRLINE2
        call LCD21
        movlw 'C'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'G'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'V'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'S'
        call LCDOUT

        call LCD1
        call CALCVOLTS

CV1:    btfsc PORTC,2
        goto CV1
        call PAUSIT

CV2:    movf PORTA,W
        andlw %00010000
        movwf STORE1
        xorwf SYNCFLAG,W
        btfsc STATUS,Z
        goto CV2 
        movf STORE1,W
        movwf SYNCFLAG
        btfss STORE1,4
        goto CV2

        call SYNCDELAY
        call GETADCVOLTS
        call LCD1
        call CALCVOLTS
   call PAUSIT

CHECKV0: btfss PORTC,1
         goto CHECKV1
         movlw 1
         addwf VOLTSMULTLSB,F
         btfsc STATUS,C
         incf VOLTSMULTMSB,F
         goto CV2

CHECKV1: btfss PORTC,0
         goto CHECKV2
         decfsz VOLTSMULTLSB,F
         goto CV2
         decfsz VOLTSMULTMSB,F
         goto CV2
         incf VOLTSMULTLSB,F
         incf VOLTSMULTMSB,F

CHECKV2: btfss PORTC,2
        goto CV2

CHANGEAMPS:
        call CLRLINE1
        call CLRLINE2
        call LCD21
        movlw 'C'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'G'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw 'P'
        call LCDOUT
        movlw 'S'
        call LCDOUT

        call SYNCDELAY
        call GETADCAMPS
        call SYNCDELAY
        call GETADCVOLTS
        call LCD1
        call CALCVOLTS

;        call CALCAMPS
        movlw AMPSMSB           ; channel 1
        movwf FSR
        call CALCAMPS

;        call CALCVOLTS
        movlw AMPSMSB           ; channel 1
        movwf FSR
        call CALCWATTS

CA1:    btfsc PORTC,2
        goto CA1
        call PAUSIT

CA2:    movf PORTA,W
        andlw %00010000
        movwf STORE1
        xorwf SYNCFLAG,W
        btfsc STATUS,Z
        goto CA2 
        movf STORE1,W
        movwf SYNCFLAG
        btfss STORE1,4
        goto CA2

        call SYNCDELAY
        call GETADCAMPS
        call SYNCDELAY
        call GETADCVOLTS
        call LCD1
        call CALCVOLTS

        movlw AMPSMSB           ; channel 1
        movwf FSR
        call CALCAMPS
;        call CALCVOLTS
        movlw ' '
        call LCDOUT
        movlw AMPSMSB           ; channel 1 *****
        movwf FSR
        call CALCWATTS
     call PAUSIT

CHECKA0: btfss PORTC,1
         goto CHECKA1
         movlw 16         ; 1
         addwf AMPSMULTLSB,F
         btfsc STATUS,C
         incf AMPSMULTMSB,F
         goto CA2

CHECKA1: btfss PORTC,0
         goto CHECKA2
;         decfsz AMPSMULTLSB,F
         movlw 16
         subwf AMPSMULTLSB,F
         btfsc STATUS,C
         goto CA2
         decfsz AMPSMULTMSB,F
         goto CA2
         incf AMPSMULTLSB,F
         incf AMPSMULTMSB,F

CHECKA2: btfss PORTC,2
        goto CA2

STORESYNC:
        movf VOLTSMULTMSB,W
        movwf PROMVAL
        movlw 0
        call SETPRM
        movf VOLTSMULTLSB,W
        movwf PROMVAL
        movlw 1
        call SETPRM

        movf AMPSMULTMSB,W
        movwf PROMVAL
        movlw 2
        call SETPRM
        movf AMPSMULTLSB,W
        movwf PROMVAL
        movlw 3
        call SETPRM

        movf SYNCDELAYMSB,W
        movwf PROMVAL
        movlw 6
        call SETPRM
        movf SYNCDELAYLSB,W
        movwf PROMVAL
        movlw 7
        call SETPRM

        call LCD21
        movlw 'S'
        call LCDOUT
        movlw 'Y'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw ' '
        call LCDOUT

        movlw 'S'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw ' '
        call LCDOUT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call CLRLINE1
        call CLRLINE2
        return

; ************

CHANGECOST:
        call CLRLINE1
        call CLRLINE2
        call LCD10
        movlw 'C'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'G'
        call LCDOUT
        movlw 'E'
        call LCDOUT

        call LCD21
        movlw 'P'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'E'
        call LCDOUT

        movlw ' '
        call LCDOUT
        movlw 'U'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'S'
        call LCDOUT
        call SHOWPRICE

CP1:    btfsc PORTC,1
        goto CP1

CP2:    call SHOWPRICE
        call PAUSIT
        movlw 1
        movwf CLKCNT

CP3:     btfss INTCON,2          ; has a timer time-out been detected?
         goto CP3                ; no
         bcf INTCON,2            ; yes
         decfsz CLKCNT,F
         goto CP3
         movlw 8
         movwf CLKCNT

CHECKCP0: btfss PORTC,0
         goto CHECKCP1
         movlw 100
         addwf UNITCOSTLSB,F
         btfsc STATUS,C
         incf UNITCOSTMSB,F
         goto CP2

CHECKCP1: btfss PORTC,1
         goto CHECKCP2
         movlw 100
         subwf UNITCOSTLSB,F
         btfsc STATUS,C
         goto CP2
         movlw 1
         subwf UNITCOSTMSB,F
         btfsc STATUS,C
         goto CP2
         incf UNITCOSTMSB,F
         movlw 100
         addwf UNITCOSTLSB,F
         goto CP2

CHECKCP2: btfss PORTC,2
        goto CP2

        call LCD21
        movlw 'P'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw 'D'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'C'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'M'
        call LCDOUT
        movlw 'A'
        call LCDOUT
        movlw 'L'
        call LCDOUT
        movlw 'S'
        call LCDOUT

CC1:    btfsc PORTC,2
        goto CC1
        call PAUSIT
        movlw 1
        movwf CLKCNT

CC2:    call SHOWPRICE

CC3:     btfss INTCON,2          ; has a timer time-out been detected?
         goto CC3                ; no
         bcf INTCON,2            ; yes
         decfsz CLKCNT,F
         goto CC3
         movlw 8
         movwf CLKCNT

CHECKCT0: btfss PORTC,0
         goto CHECKCT1
         movlw 1
         addwf UNITCOSTLSB,F
         btfsc STATUS,C
         incf UNITCOSTMSB,F
         goto CC2

CHECKCT1: btfss PORTC,1
         goto CHECKCT2
         decfsz UNITCOSTLSB,F
         goto CC2
         movf UNITCOSTMSB,W
         iorwf UNITCOSTLSB,W
         btfsc STATUS,Z
         incf UNITCOSTLSB,F
         goto CC2

CHECKCT2: btfss PORTC,2
         goto CC2

CHANGEMAINSFREQ:
        btfsc PORTC,2
        goto CHANGEMAINSFREQ
        call CLRLINE2

MAINSHZ: call LCD1
        movlw '5'
        btfsc HERTZFLAG,0
        movlw '6'
        call LCDOUT
        movlw '0'
        call LCDOUT
        movlw 'H'
        call LCDOUT
        movlw 'z'
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT

        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT
        call PAUSIT

CHECKHZ: btfss PORTC,1
         goto CHECKHZ2
        incf HERTZFLAG,F
        movlw 50
        btfsc HERTZFLAG,0
        movlw 60
        movwf MAINSFREQ
        goto MAINSHZ

CHECKHZ2: btfss PORTC,2
        goto CHECKHZ

STORECOST: movf UNITCOSTMSB,W
        movwf PROMVAL
        movlw 4
        call SETPRM
        movf  UNITCOSTLSB,W
        movwf PROMVAL
        movlw 5
        call SETPRM

        movf HERTZFLAG,W
        movwf PROMVAL
        movlw 10
        call SETPRM

        call CLRLINE1
        call CLRLINE2

        call LCD21
        movlw 'S'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw 'O'
        call LCDOUT
        movlw 'R'
        call LCDOUT
        movlw 'E'
        call LCDOUT
        movlw 'D'
        call LCDOUT

CHECKHZ3: btfsc PORTC,2
        goto CHECKHZ3
        return

SHOWPRICE: movf UNITCOSTMSB,W
        movwf REGA1
        movf UNITCOSTLSB,W
        movwf REGA0
        clrf REGA2
        clrf REGA3
        call LCD1
        call BIN2DEC
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT6,W
        call LCDOUT
        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT
        movf DIGIT9,W
        iorlw 48
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        return

; ************

LCDSET: clrf LOOP        ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOP,W      ;get table address
        bsf PCLATH,3
        call TABLCD      ;get set-up instruction
        clrf PCLATH
        call LCDOUT      ;perform it
        incf LOOP,F      ;inc loop
        btfss LOOP,3     ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        return

SETUP:  clrf INTCON
        call PAUSIT
        call LCDSET
        clrf INTCON
        call PAUSIT

        call SHOWTITLE

        call JOESETBAUD  ; set baud rate

        movlw 5
        movwf CLKCNT

        movlw %00000000     ; T1 ext osc disable (bit3=0), T1 stopped (bit0=0), internal clock (bit1=0), bit2 dont care
        movwf T1CON

        clrf TMR1L       ; reset timer 1
        clrf TMR1H

        clrf TOTALCOST1LSB
        clrf TOTALCOST1NSB
        clrf TOTALCOST1NMSB
        clrf TOTALCOST1MSB
        clrf TOTALCOST2LSB
        clrf TOTALCOST2NSB
        clrf TOTALCOST2NMSB
        clrf TOTALCOST2MSB
        clrf CLKSEC
        clrf CLKMIN
        clrf CLKHRSLSB
        clrf CLKHRSMSB
        clrf SYNCFLAG
        clrf PAGEFLAG
        clrf DISPLAYCOUNT
        call CHIPCOUNT

        btfss PORTC,2   ; is external serial chip clearance needed?
        goto SHOWC2
        call CLEARIT    ; yes
        call CLRLINE2
        call CLEARADR

SHOWC2: movlw 0          ; get correction & cost values
        call PRMGET
        movwf VOLTSMULTMSB
        movlw 1
        call PRMGET
        movwf VOLTSMULTLSB
        movlw 2
        call PRMGET
        movwf AMPSMULTMSB
        movlw 3
        call PRMGET
        movwf AMPSMULTLSB
        movlw 4
        call PRMGET
        movwf UNITCOSTMSB
        movlw 5
        call PRMGET
        movwf UNITCOSTLSB
        movlw 6
        call PRMGET
        movwf SYNCDELAYMSB
        movlw 7
        call PRMGET
        movwf SYNCDELAYLSB
        movlw 8
        call PRMGET
        movwf WADDRH
        movlw 9
        call PRMGET
        movwf WADDRL
        movlw 10
        call PRMGET
        movwf HERTZFLAG
        movlw 50
        btfsc HERTZFLAG,0
        movlw 60
        movwf MAINSFREQ
        movlw 11              ; get timing values for HERTZMSB 50Hz
        call PRMGET
        movwf HERTZMSB
        movlw 12              ; get timing values for HERTZMSB 50Hz
        call PRMGET
        movwf HERTZLSB

        btfss HERTZFLAG,0
        return

        movlw 13              ; get timing values for HERTZMSB 60Hz
        call PRMGET
        movwf HERTZMSB
        movlw 14              ; get timing values for HERTZMSB 60Hz
        call PRMGET
        movwf HERTZLSB
        return

PAGECHANGE: incf PAGEFLAG,F  ; check which LCD page is to be shown
        movlw 16
        movwf LOOP
        btfss PAGEFLAG,0
        goto BACKIT

FORWARDS: movlw %00011000
        call LCDLIN
        decfsz LOOP,F
        goto FORWARDS
        return

BACKIT: movlw %00000010  ; LCD return home, cursor & RAM to zero
        call LCDLIN
        call PAUSIT
        return

;        movlw %00011100
;        call LCDLIN
;        decfsz LOOP,F
;        goto BACKIT
;        return

SHOWCOUNT: call LCD17
        movf WADDRH,W
        movwf REGA1
        movf WADDRL,W
        movwf REGA0
        clrf REGA2
        clrf REGA3
        call BIN2DEC
        call SHOWDIG3
        return

SETTIMER1: bcf T1CON,0       ; stop timer 1
        movf HERTZLSB,W
        movwf TMR1L        ; reset timer 1
        movf HERTZMSB,W
        movwf TMR1H
        bcf PIR1,0        ; clear timer rollover flag
        bsf T1CON,0       ; start timer 1
        return

; *************

        ORG $0800

TABLCD: addwf PCL,F      ;LCD initialisation table
        retlw %00110011  ;initialise lcd - first byte
        retlw %00110011  ;2nd byte (repeat of first)
        retlw %00110010  ;set for 4-bit operation
        retlw %00101100  ;set for 2 lines
        retlw %00000110  ;set entry mode to increment each address
        retlw %00001100  ;set display on, cursor off, blink off
        retlw %00000001  ;clear display
        retlw %00000010  ;return home, cursor & RAM to zero
                         ;end inititalisation table

MESSAG1: addwf PCL,F
        retlw 'P'
        retlw 'I'
        retlw 'C'
        retlw ' '
        retlw 'E'
        retlw 'L'
        retlw 'E'
        retlw 'C'
        retlw 'T'
        retlw 'R'
        retlw 'I'
        retlw 'C'
        retlw ' '
        retlw 'M'
        retlw 'K'
        retlw '2'

MESSAG2: addwf PCL,F
        retlw 'C'
        retlw 'L'
        retlw 'E'
        retlw 'A'
        retlw 'R'
        retlw 'I'
        retlw 'N'
        retlw 'G'
        retlw ' '
        retlw 'E'
        retlw 'E'
        retlw 'P'
        retlw 'R'
        retlw 'O'
        retlw 'M'
        retlw ' '

MESSAG3: addwf PCL,F
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw ' '
        retlw '0'
        retlw ' '
        retlw 'O'
        retlw 'F'
        retlw ' '
        retlw 'C'
        retlw 'H'
        retlw 'I'
        retlw 'P'
        retlw ' '
        retlw ' '

MESSAG4:  addwf PCL,F
           retlw 'S'
           retlw 'E'
           retlw 'R'
           retlw 'I'
           retlw 'A'
           retlw 'L'
           retlw ' '
           retlw 'O'
           retlw 'C'
           retlw 'X'
           retlw ' '
           retlw 'T'
           retlw 'O'
           retlw ' '
           retlw 'P'
           retlw 'C'

        ORG $2100

        DE $0E        ; 0 volts divider MSB
        DE $AA        ; 1 volts divider LSB
        DE $16        ; 2 amps divider MSB
        DE $9E        ; 3 amps divider LSB
        DE $03        ; 4 cost per unit (kWh) MSB   (8.37p)
        DE $45        ; 5 cost per unit (kWh) LSB
        DE $05        ; 6 sync delay MSB
        DE $6B        ; 7 sync delay LSB
        DE 0          ; 8 memcount MSB
        DE 0          ; 9 memcount LSB
        DE 0          ; 10 mains frequency flag; 0 = 50Hz; 1 = 60Hz
        DE $E0        ; 11 HERTZMSB for 50Hz timer delay value
        DE $00        ; 12 HERTZLSB for 50Hz timer delay value
        DE $E5        ; 13 HERTZMSB for 60Hz timer delay value
        DE $55        ; 14 HERTZLSB for 60Hz timer delay value

        DE 0,0,0,0

        END
