;-----------------------------------------------------
;This universal sample program runs on the following
;processor types: PIC16C5X, PIC16CXX, and PIC17CXX.
;
;Execution starts at instruction 50.
;The loop routine executes seven times.  
;       The routines, ReduceA and DoubleB, 
;       each execute one time for each loop cycle.
;After the loop executes seven times, the instruction 
;at location 59 returns the program counter to start.
;
;
;Start initializes:     AA = 255, (AA decreases to  128)
;                       BB =   1, (BB increases to  128)
;                       CC =   7, (CC decrements to   0)
;                       w  =   7
;                    wreg =   7
;           
;The sample program calculates values as follows:
;Cycle #  AA (AA=AA-BB) BB (BB=BB+BB)  CC (CC=CC-1)    
;  0           255           1           7
;  1           254           2           6
;  2           252           4           5
;  3           248           8           4
;  4           240          16           3
;  5           224          32           2  
;  6           192          64           1   
;  7           128         128           0  
;
;Caution:  Enter the device name printed on the probe 
;          connected to your pod before assembling 
;          this code.
;-----------------------------------------------------
;
        list p=16c64, f=inhx8m  ;Enter device name 
                                ;printed on the probe
                                ;connected to your pod.
;------------------------------------------------------
;Please define ScratchPadRam here:
;If you are using PIC16C5X define "ScratchPadRam equ 0x10" 
;else define "ScratchPadRam equ 0x20"
;-------------------------------------------------------
ScratchPadRam   equ     0x20
AA      equ     ScratchPadRam+0
BB      equ     ScratchPadRam+1
CC      equ     ScratchPadRam+2
w       equ     0
;        
        org     0       ;start address 0
        goto    start
        org     0x50
;
start
        movlw   .255
        movwf   AA      ;AA=255 start
        movlw   .1
        movwf   BB      ;BB=1   start
        movlw   .7
        movwf   CC      ;CC=7   start
loop                    
        call    ReduceA ;run 7 loops
        decfsz  CC      ;CC=CC-1
        goto    loop   
        goto    start   ;initialize
;
ReduceA                 
        swapf   BB
        swapf   BB,w
        swapf   BB
        subwf   AA      ;AA=AA-BB
        call    DoubleB
        retlw   0
;
DoubleB                 
        swapf   BB
        swapf   BB,w
        swapf   BB
        addwf   BB       ;BB=BB+BB
        retlw   0
;
        end



