;SLAVEMSG500A 27JUN06 - COPYRIGHT JOHN BECKER - EPE MOVING MESSAGE DISPLAY SLAVE

;PIC16F628, INTERNAL OSC WDT OFF, POR ON, INTRC 100

; command codes:
; 1 Setup PIC ID numbers                  ** **
; 2 Show PIC IDs                          ** **
; 3 static characters to slaves           **
; 4 receive normal data from PC for scrolling **
; 5 clear anim & static flags             **
; 6 halt display                          **
; 7 receive animate display data from PC  - not used for slaves
; 8 Sync Off                              **
; 9 Sync On                               **
; 10 send on receive animate display data **
; 11 send on anim rate                    **
; 12 not used by slaves
; 13 moving message mode                  ** **
; 14 code to select animation mode        ** **
; 15 static display mode                  ** **
; 16 moving message stop                  ** **
; 17 check PIC IDs                        ** **
; 18 Stop animate mode                    ** **
; 19 Stop static mode                     ** **
; 20 Run Mode
; 21 Program Mode
; 22 tell slaves to expect static data
; 23 Show sync

; Slave eeprom use
; 0 - 119 general
; 120 Anim rate
; 121 Mode flag - 0 normal moving message
;                 1 animation
;                 2 static text
; 122 Active mode for this PIC
; 123 Sync flag
; 127 PIC ID

#DEFINE BANK0 BCF $03,5
#DEFINE BANK1 BSF $03,5

        List P = PIC16F628, R=DEC; 
        __CONFIG   h'3F30'

        include P16F628.inc

        CBLOCK
STORE1
STORE2
STORE3
STORERB
STORERB2
COUNT1
COUNT2
COUNT3
COLUMN0A
COLUMN1A
COLUMN2A
COLUMN3A
COLUMN4A
COLUMN5A
STORECOL1
STORECOL2
STORECOL3
STORECOL4
STORECOL5
PICID
LOOP
ANIMATEFLAG
RCFLAG
SYNCFLAG
ACTIVEMODE
DELAYVALMAIN
DELAYVAL1
DELAYVAL2
ANIMRATE
ANIMADDRESS
ANIMSTORE    ; extends for a further 35 bytes - dont add REGs after ANIMSTORE
        ENDC

PROMVAL .EQU $70    ; in both pages
SPBRG   .EQU $99    ; not in INC file for some odd reason.  Bank 1

; **************

        .ORG 0
        goto GIEOFF
        .ORG 4          ; Interrupt vector address
        goto GIEOFF
        .ORG 5          ; Start of program memory

GIEOFF: BCF INTCON,GIE  ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto START

ACTIVEMODEROUTE:
        movf ACTIVEMODE,W
        andlw %00000011
        addwf PCL,F
        goto MOVINGMODE2  ; 0 normal moving message
        goto RUNANIMATE  ; 1 run animation
        goto SHOWSTATIC  ; 2 run static text
        goto RUNMODE2    ; 3 RUN mode

ROUTEITRUNMODE: movf STORE1,W
        andlw 31
	addwf PCL,F
        goto ACTIVEMODEROUTE   ; 0 not used at all
        goto SETUP             ; 1 Setup
        goto ACTIVEMODEROUTE   ; 2 not used at all
        goto GETSTATIC         ; 3 receive & send on static characters to slaves
        goto ACTIVEMODEROUTE   ; 4 not used by slaves 
        goto CLEARFLAGS        ; 5 clear anim & static flags
        goto ACTIVEMODEROUTE   ; 6 not used in slaves
        goto ACTIVEMODEROUTE   ; 7 master only  
        goto SENDONSYNC        ; 8 sync off
        goto SENDONSYNC        ; 9 sync on
        goto SENDANIMATION     ; 10 used to receive animation data, slave command only
        goto SENDONANIMRATE    ; 11 send on animate rate change to slaves
        goto ACTIVEMODEROUTE   ; 12 not used by slaves
        goto MOVINGMODE        ; 13 start moving message
        goto TRIGRUNANIMATE    ; 14 start animation
        goto TRIGSHOWSTATIC    ; 15 show static mode
        goto STOPMOVING        ; 16 stop moving message
        goto CHECKPICIDS       ; 17 Check PIC IDs
        goto STOPANIMATE       ; 18 Stop animate mode
        goto STOPSTATIC        ; 19 Stop static mode
        goto RUNMODE           ; 20 set into run wait mode
        goto ACTIVEMODEROUTE   ; 21 not used
        goto RECEIVESTATIC     ; 22 tell slaves to expect static data
        goto SHOWSYNC          ; 23 tell slaves to show sync

;*******************

START:  movlw %10000000
        movwf PORTA
        movlw 255
        movwf PORTB         ; set all display cathodes high

        movlw $07
        movwf CMCON

        BANK1
        movlw %00000110     ; RB1 & RB2 for serial
        movwf TRISB
        movlw %00010000     ; RA4 as input for PIC mode use
        movwf TRISA
        BANK0

        call JOESETBAUD     ; initialise serial BAUD rate etc

;****************** START OF MAIN

MAIN:   clrf PORTB
        clrf STORE1
        clrf STORE2
        clrf STORE3
        
        clrf PORTA
        clrf COUNT1
        clrf COUNT2
        clrf COUNT3

        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A

        movlw 123         ; get sync flag
        call PRMGET
        iorlw 8
        movwf SYNCFLAG

        movlw 127
        call PRMGET       ; get PIC ID from EEPROM address 127
        movwf PICID

        movlw 121         ; ANIMATEFLAG
        call PRMGET
        movwf ANIMATEFLAG
        call CLEARSCREEN
        clrf ACTIVEMODE
        goto ACTIVEMODEROUTE

;*****************

CONVERT: movwf STORE1   ; converts value to suit LED matrix
        clrf STORE3
        clrf STORERB
        clrf STORERB2

        btfsc STORE1,0  ; reverse order
        bsf STORERB2,6
        btfsc STORE1,1
        bsf STORERB2,5
        btfsc STORE1,2
        bsf STORERB2,4
        btfsc STORE1,3
        bsf STORERB2,3
        btfsc STORE1,4
        bsf STORERB2,2
        btfsc STORE1,5
        bsf STORERB2,1
        btfsc STORE1,6
        bsf STORERB2,0

        movf STORERB2,W  ; replace STORE1 with new value, reversing order
        movwf STORE1

                         ; change bit order
;row1:  controlled by RB6
        btfsc STORE1,0
        bsf STORERB,6

;row2:  controlled by RB5
        btfsc STORE1,1
        bsf STORERB,5

;row3:  controlled by RB7
        btfsc STORE1,2
        bsf STORERB,7

;row4:  controlled by RB4
        btfsc STORE1,3
        bsf STORERB,4

;row6:  controlled by RB0
        btfsc STORE1,5
        bsf STORERB,0

;row7:  controlled by RB3
        btfsc STORE1,6
        bsf STORERB,3

        movlw %10110000
        movwf PORTA

        comf STORERB,W   ; invert logic to suit common anode display
        movwf PORTB

;row5:  controlled by RA7
        btfss STORE1,4
        bsf STORE3,7
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above $70
SETPRM: 
        BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR1 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR1
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x devices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        BANK0
        return

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

JOESETBAUD:
        BANK1                   ; Configure the baud rate generator
        movlw 25                ; BRG for 9600baud from 4MHz, brgh=1
                                ; Internal osc is 4MHz
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TxByte:
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer:
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

MOVINGMODE:               ; show moving message
        movlw 13          ; tell other slaves now in Moving Mode
        call TXBYTE
        movf ACTIVEMODE,W
        btfss STATUS,Z
        goto ACTIVEMODEROUTE

MOVINGMODE2:

MM1:    call SHOWCHAR2    ; yes, so show moving
        movf RCFLAG,W     ;
        btfsc STATUS,Z    ; is a command recd ?
        goto MM1          ; no, so continue
        btfsc RCFLAG,7    ; is normal data coming in?
        goto MM2          ; yes
MM3:    movf RCFLAG,W     ; no, it's a command
        movwf STORE1      ; action command val and route it
        goto ROUTEITRUNMODE

MM2:    movf COLUMN1A,W
        movwf COLUMN0A
        movf COLUMN2A,W
        movwf COLUMN1A
        movf COLUMN3A,W
        movwf COLUMN2A
        movf COLUMN4A,W
        movwf COLUMN3A
        movf COLUMN5A,W
        movwf COLUMN4A
        movf RCFLAG,W
        movwf COLUMN5A
        movf COLUMN0A,W   ; send outgoing value to next PIC
        iorlw 128   
        call TXBYTE
        goto MM1

SHOWCHAR2:                ; activate normal display multiplexing
        movlw 2
        movwf DELAYVALMAIN
        clrf RCFLAG

COL21:  movf COLUMN1A,W   ; show column 1
        call CONVERT
        movlw %00000010   ; pin 18 RA1 = 1
        iorwf STORE3,W
        movwf PORTA

        movf DELAYVALMAIN,W
        movwf DELAYVAL1
        clrf DELAYVAL2

COL21A: btfss PIR1,RCIF   ; Check for any RX'd data
        goto COL21B       ; nothing recd
        movf RCREG,W      ; yes, so action it
        movwf RCFLAG
        return
COL21B: decfsz DELAYVAL2,F
        goto COL21A
        decfsz DELAYVAL1,F
        goto COL21A

COL22:  movf COLUMN2A,W    ; show column 2
        call CONVERT
        movlw %00000100    ; pin 2 RA2 = 1
        iorwf STORE3,W
        movwf PORTA
        movf DELAYVALMAIN,W
        movwf DELAYVAL1
        clrf DELAYVAL2

COL22A: btfss PIR1,RCIF   ; Check for any RX'd data
        goto COL22B       ; nothing recd
        movf RCREG,W      ; yes, so action it
        movwf RCFLAG
        return
COL22B: decfsz DELAYVAL2,F
        goto COL22A
        decfsz DELAYVAL1,F
        goto COL22A

COL23:  movf COLUMN3A,W    ; show column 3
        call CONVERT
        movlw %00001000    ; pin 1 RA3 = 1
        iorwf STORE3,W
        movwf PORTA
        movf DELAYVALMAIN,W
        movwf DELAYVAL1
        clrf DELAYVAL2

COL23A: btfss PIR1,RCIF   ; Check for any RX'd data
        goto COL23B       ; nothing recd
        movf RCREG,W      ; yes, so action it
        movwf RCFLAG
        return
COL23B: decfsz DELAYVAL2,F
        goto COL23A
        decfsz DELAYVAL1,F
        goto COL23A

COL24:  movf COLUMN4A,W    ; show column 4
        call CONVERT
        movlw %00000001    ; pin 17 RA0 = 1
        iorwf STORE3,W
        movwf PORTA
        movf DELAYVALMAIN,W
        movwf DELAYVAL1
        clrf DELAYVAL2

COL24A: btfss PIR1,RCIF   ; Check for any RX'd data
        goto COL24B       ; nothing recd
        movf RCREG,W      ; yes, so action it
        movwf RCFLAG
        return
COL24B: decfsz DELAYVAL2,F
        goto COL24A
        decfsz DELAYVAL1,F
        goto COL24A

COL25:  movf COLUMN5A,W    ; show column 5
        call CONVERT
        movlw %01000000    ; pin 15 RA6 = 1
        iorwf STORE3,W
        movwf PORTA
        movf DELAYVALMAIN,W
        movwf DELAYVAL1
        clrf DELAYVAL2

COL25A: btfss PIR1,RCIF   ; Check for any RX'd data
        goto COL25B       ; nothing recd
        movf RCREG,W      ; is a command, so action it
        movwf RCFLAG
        return
COL25B: decfsz DELAYVAL2,F
        goto COL25A
        decfsz DELAYVAL1,F
        goto COL25A
        return

;  *************

SHOWCHAR3:                 ; used only by author for test purposes
COL321:  movf COLUMN1A,W
        call CONVERT
        movlw %00000010    ; pin 18 RA1 = 1
        iorwf STORE3,W
        movwf PORTA
        call DELAY3

COL322:  movf COLUMN2A,W
        call CONVERT
        movlw %00000100    ; pin 2 RA2 = 1
        iorwf STORE3,W
        movwf PORTA
        call DELAY3

COL323:  movf COLUMN3A,W
        call CONVERT
        movlw %00001000    ; pin 1 RA3 = 1
        iorwf STORE3,W
        movwf PORTA
        call DELAY3

COL324:  movf COLUMN4A,W
        call CONVERT
        movlw %00000001    ; pin 17 RA0 = 1
        iorwf STORE3,W
        movwf PORTA
        call DELAY3

COL325:  movf COLUMN5A,W
        call CONVERT
        movlw %01000000    ; pin 15 RA6 = 1
        iorwf STORE3,W
        movwf PORTA
        call DELAY3
        return

DELAY3: clrf STORE2
D32:    decfsz STORE2,F
        goto D32
D33:    decfsz STORE2,F
        goto D33
D34:    decfsz STORE2,F
        goto D34
D35:    decfsz STORE2,F
        goto D35
        return

; ***************

GETANIMATE: clrf LOOP
GETA0:  btfss PIR1,RCIF     ; Check for any RX'd data
        goto GETA0          ; Nothing RX'd
        movf RCREG,W        ; get ANIMATE data
        movwf PROMVAL       ; put out to EEPROM   
        movf LOOP,W
        call SETPRM
        incf LOOP,F
        movf LOOP,W
        xorlw 35
        btfss STATUS,Z
        goto GETA0

GETAX:  btfss PIR1,RCIF     ; Check for any RX'd data
        goto GETAX          ; Nothing RX'd
        movf RCREG,W        ; get ANIMATE data rate
        movwf PROMVAL       ; put out to EEPROM   
        movlw 120
        call SETPRM
        movlw 1
        movwf PROMVAL       ; put out to EEPROM   
        movlw 121           ; Mode fLAG - ANIMATEFLAG
        call SETPRM

        bsf ANIMATEFLAG,0

RUNANIMATE: movlw 120
        call PRMGET
        movwf COUNT1
        clrf LOOP
        movlw 1
        movwf ACTIVEMODE
        movwf PROMVAL

        movlw 122
        call SETPRM

RUNAN1: call ANIMATELOOP

RUNAN2: call SHOWCHAR2
        movf RCFLAG,W     ;
        btfsc STATUS,Z    ; is a command recd ?
        goto RUNAN2A      ; no, so continue
        btfsc RCFLAG,7    ; is normal data coming in?
        goto RUNAN4       ; yes
        movf RCFLAG,W     ; no, it's a command
        movwf STORE1      ; action command val and route it
        goto ROUTEITRUNMODE

RUNAN4: movf STORECOL5,W    ; causes apparent delay as message "passes behind"
        call TXBYTE         ; send STORECOL on to next PIC
        movf STORECOL4,W    ; ripple forward with rest of STORECOLS
        movwf STORECOL5
        movf STORECOL3,W
        movwf STORECOL4
        movf STORECOL2,W
        movwf STORECOL3
        movf STORECOL1,W
        movwf STORECOL2
        movf RCFLAG,W       ; and add latest to STORECOL1
        movwf STORECOL1
        goto RUNAN3         ; continue

RUNAN2A:
RUNAN3: decfsz COUNT1,F     ; mothing recd
        goto RUNAN2
        movlw 120           ; get animation rate
        call PRMGET
        movwf COUNT1
        incf LOOP,F
        movf LOOP,W
        xorlw 35
        btfss STATUS,Z
        goto RUNAN1

        movf SYNCFLAG,W  ; yes
        btfsc SYNCFLAG,0 ; is sync on ?
        call TXBYTE      ; yes , so tell next PIC to restart loop
        goto RUNANIMATE  ; restart this PIC's loop

ANIMATELOOP: movf LOOP,W
        call PRMGET
        movwf COLUMN1A
        incf LOOP,F
        movf LOOP,W
        call PRMGET
        movwf COLUMN2A
        incf LOOP,F
        movf LOOP,W
        call PRMGET
        movwf COLUMN3A
        incf LOOP,F
        movf LOOP,W
        call PRMGET
        movwf COLUMN4A
        incf LOOP,F
        movf LOOP,W
        call PRMGET
        movwf COLUMN5A
        return

***************

SENDANIMATION:
SA0:    btfss PIR1,RCIF       ; Check for any RX'd data
        goto SA0              ; Nothing RX'd
        movf RCREG,W          ; Store the RX'd data in 'W'
        andlw 127             ; limit to less than 128
        movwf ANIMADDRESS     ; get PIC destination address
        movlw ANIMSTORE
        movwf FSR
        clrf LOOP

; store data into RAM

SA1:    btfss PIR1,RCIF       ; Check for any RX'd data - get anim data
        goto SA1              ; Nothing RX'd
        movf RCREG,W          ; Store the RX'd data in 'W'
        movwf INDF            ; store it into ANIMSTORE via FSR
        incf FSR,F
        incf LOOP,F
        movf LOOP,W
        xorlw 35
        btfss STATUS,Z
        goto SA1

SA1A:   btfss PIR1,RCIF       ; Check for any RX'd data - get anim rate
        goto SA1A             ; Nothing RX'd
        movf RCREG,W          ; Store the RX'd data in 'W'
        movwf ANIMRATE        ; anim rate

SA1C:   btfss PIR1,RCIF       ; Check for any RX'd data - get anim rate
        goto SA1C             ; Nothing RX'd
        movf RCREG,W          ; Store the RX'd data in 'W'
        movwf SYNCFLAG        ; sync flag

; is data meant for this PIC?

        movlw 127            ; get which PIC it's meant for
        call PRMGET          ; get PIC ID
        movwf STORE1         ; temp store it
        movf ANIMADDRESS,W   ; get PIC destination address
        andlw %01111111      ; AND to remove bit 7
        xorwf STORE1,W       ; xor with STORE1
        btfsc STATUS,Z       ; are vals equal?
        goto STOREANIMDATA   ; yes, store it into eeprom

;no - send on to next PIC

        movlw ANIMSTORE      ; get address of ANIMSTORE
        movwf FSR
        clrf LOOP
        movlw 10
        call TXBYTE          ; send anim coming to next PIC
SA2:    decfsz LOOP,F        ; wait a bit
        goto SA2

        movf ANIMADDRESS,W
        iorlw 128            ; OR with 128
        call TXBYTE          ; send anim address to next PIC

SA3:    movf INDF,W
        call TXBYTE          ; send anim data on to next PIC
        incf FSR,F
        incf LOOP,F
        movf LOOP,W
        xorlw 35
        btfss STATUS,Z
        goto SA3

        movf ANIMRATE,W
        call TXBYTE

        movf SYNCFLAG,W
        call TXBYTE

        movf ANIMADDRESS,W   ; is SendAll recd in ANIMADDRESS?
        xorlw 127
        btfsc STATUS,Z
        goto STOREANIMDATA   ; yes, store data into eeprom
        goto ACTIVEMODEROUTE ; no, so continue

; store recd data into eeprom


STOREANIMDATA:
        movlw ANIMSTORE   ; get address of ANIMSTORE
        movwf FSR
        clrf LOOP

SA1B:   movf INDF,W
        movwf PROMVAL
        movf LOOP,W
        call SETPRM
        incf FSR,F
        incf LOOP,F
        movf LOOP,W
        xorlw 35
        btfss STATUS,Z
        goto SA1B

        movf ANIMRATE,W      ; store ANIMRATE to eeprom
        andlw %01111111
        movwf PROMVAL
        movlw 120
        call SETPRM

        movlw 1              ; set for ANIMATION routing
        movwf PROMVAL
        movlw 121
        call SETPRM
        goto RUNANIMATE


DOSENDANIMATION:
        goto SENDANIMATION

GETSTATIC:            ; show static data
        movlw 3
        call TXBYTE   ; send on command to next PIC

GSX5:   movf COLUMN1A,W       ; is it a zero char? (space)
        iorwf COLUMN2A,W
        iorwf COLUMN3A,W
        iorwf COLUMN4A,W
        iorwf COLUMN5A,W
        andlw %01111111
        btfsc STATUS,Z
        goto ACTIVEMODEROUTE

        movf COLUMN1A,W       ; store new cols and use
        iorlw 128
        movwf PROMVAL
        movlw 40
        call SETPRM

        movf COLUMN2A,W
        iorlw 128
        movwf PROMVAL
        movlw 41
        call SETPRM

        movf COLUMN3A,W
        iorlw 128
        movwf PROMVAL
        movlw 42
        call SETPRM

        movf COLUMN4A,W
        iorlw 128
        movwf PROMVAL
        movlw 43
        call SETPRM

        movf COLUMN5A,W
        iorlw 128
        movwf PROMVAL
        movlw 44
        call SETPRM

        movlw 2              ; set for STATIC routing
        movwf ACTIVEMODE
        movwf PROMVAL
        movlw 121
        call SETPRM
        goto ACTIVEMODEROUTE

SHOWSTATIC:
        movlw 40
        call PRMGET
        movwf COLUMN1A
        movlw 41
        call PRMGET
        movwf COLUMN2A
        movlw 42
        call PRMGET
        movwf COLUMN3A
        movlw 43
        call PRMGET
        movwf COLUMN4A
        movlw 44
        call PRMGET
        movwf COLUMN5A

GSCY:   call SHOWCHAR2

GSCY1:  call SHOWCHAR2    ; show static
        movf RCFLAG,W     ;
        btfsc STATUS,Z    ; is a command recd ?
        goto GSCY1        ; no, so continue
        btfsc RCFLAG,7    ; is normal data coming in?
        goto GSCY2A       ; yes
GSCY3:  movf RCFLAG,W     ; no, it's a command

        movwf STORE1      ; action command val and route it
        goto ROUTEITRUNMODE

GSCY2A: movf STORECOL5,W    ; causes apparent delay as message "passes behind"
        iorlw 128
        call TXBYTE         ; yes, send STORECOL on to next PIC
        movf STORECOL4,W    ; ripple forward with rest of STORECOLS
        movwf STORECOL5
        movf STORECOL3,W
        movwf STORECOL4
        movf STORECOL2,W
        movwf STORECOL3
        movf STORECOL1,W
        movwf STORECOL2
        movf RCFLAG,W       ; and add latest to STORECOL1
        movwf STORECOL1
        goto GSCY            ; continue

GSCY2:  btfsc RCFLAG,7
        goto GSCY

        movf RCFLAG,W
        movwf STORE1
        btfss STATUS,Z       ; is nothing recd?
        call ROUTEITRUNMODE  ; yes, something is
        goto GSCY            ; no, continue

TRIGRUNANIMATE:              ; animation mode
        movlw 14
        call TXBYTE
TRIGRUNANIMATE2:
        movlw 121
        call PRMGET
        xorlw 1
        btfss STATUS,Z       ; is anim flag active?
        goto ACTIVEMODEROUTE ; no, continue
        movlw 1              ; yes
        movwf ACTIVEMODE

        movwf PROMVAL
        movlw 122
        call SETPRM
        goto ACTIVEMODEROUTE

TRIGSHOWSTATIC:              ; static char mode
        movlw 15
        call TXBYTE
        movlw 121
        call PRMGET
        xorlw 2
        btfss STATUS,Z       ; is static flag active?
        goto ACTIVEMODEROUTE ; no, continue
        movlw 2              ; yes
        movwf ACTIVEMODE
        movwf PROMVAL
        movlw 122
        call SETPRM
        clrf STORECOL1
        clrf STORECOL2
        clrf STORECOL3
        clrf STORECOL4
        clrf STORECOL5
        goto ACTIVEMODEROUTE

; **************

SA4:    movwf COLUMN1A    ; used only by author for test purposes
        movwf COLUMN2A
        movwf COLUMN3A
        movwf COLUMN4A
        movwf COLUMN5A

SA5:    call SHOWCHAR3
        goto SA5

; **************

STOPANIMATE: movlw 18         ; 18 Stop animate mode
	call TXBYTE
        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A
        clrf PORTA
        clrf PORTB

	movlw 121
	call PRMGET
	xorlw 1		      ; is mode type = 1 ?
        btfss STATUS,Z
        goto ACTIVEMODEROUTE
	clrf ACTIVEMODE	      ; yes
        clrf PROMVAL
        movlw 122
        call SETPRM
        goto ACTIVEMODEROUTE

STOPSTATIC:  movlw 19          ; 19 Stop static mode
	call TXBYTE
	movlw 121
	call PRMGET
        xorlw 2                ; is mode type = 2 ?
        btfss STATUS,Z
        goto ACTIVEMODEROUTE
        movlw 0
        movwf ACTIVEMODE       ; yes, set for moving mode
        clrf PROMVAL
        movlw 122
        call SETPRM
        call CLEARSCREEN
        goto ACTIVEMODEROUTE

RUNMODE: movlw 20
        call TXBYTE

RUNMODE2: call CLEARSCREEN

RM1:    btfss PIR1,RCIF       ; Check for any RX'd data
        goto RM1              ; Nothing RX'd
        btfsc RCREG,7         ; is normal data coming in ?
        goto RM1              ; yes, so continue waiting
        movf RCREG,W          ; no, a command, so action it
        movwf STORE1
        goto ROUTEITRUNMODE

; ************

SETUP:                        ; command of 1 has been received from previous PIC
                              ; now wait address value - PIC ID val
        movlw 1               ; alert next PIC to address data coming next
        call TXBYTE
        call CLEARSCREEN

SETNEXT: btfss PIR1,RCIF      ; Check for any RX'd data
        goto SETNEXT          ; Nothing RX'd
        movf RCREG,W
        movwf PROMVAL         ; store address val recd
        addlw 1               ; inc address value
        call TXBYTE           ; send to next PIC
SNX3:   movlw 127             ; put PROMVAL into eeprom byte 127
        call SETPRM
        goto CHECKPICIDS2

CLEARFLAGS:                  ; clear anim & static flags
        movlw 5
        call TXBYTE
        movlw 0
        movwf PROMVAL
        movlw 121
        call SETPRM
        movlw 122
        call SETPRM
        clrf ACTIVEMODE
        goto ACTIVEMODEROUTE

SENDONSYNC: movf STORE1,W
        movwf SYNCFLAG          ; 8 or 9 
        movwf PROMVAL
        call TXBYTE
        movlw 123               ; store sync flag
        call SETPRM
        goto ACTIVEMODEROUTE

SENDONANIMRATE: movlw 11
        call TXBYTE
SOA1:   btfss PIR1,RCIF     ; yes, Check for any RX'd data
        goto SOA1           ; Nothing RX'd
        movf RCREG,W        ; get anim rate value
        movwf ANIMRATE
        movwf PROMVAL
        movlw 120
        call SETPRM

        movf ANIMRATE,W
        call TXBYTE
        goto ACTIVEMODEROUTE

CHECKPICIDS: movlw 17
        call TXBYTE
        call CLEARSCREEN
CHECKPICIDS2:
        movlw 127
        call PRMGET       ; get PIC ID from EEPROM address 127
        movwf COLUMN1A
        movwf COLUMN2A
        movwf COLUMN3A
        movwf COLUMN4A
        movwf COLUMN5A
SHOWID: call SHOWCHAR2
        movf RCFLAG,W     ;
        btfsc STATUS,Z    ; is a command recd ?
        goto SHOWID       ; no, so continue
        btfsc RCFLAG,7    ; is normal data coming in?
        goto SHOWID       ; yes, so continue
SID3:   movf RCFLAG,W     ; no, it's a command
        movwf STORE1      ; action command val and route it
        goto ROUTEITRUNMODE


STOPMOVING:  movlw 16
         call TXBYTE
        movf ACTIVEMODE,W   ; if activing mode is "moving" then clear screen
        btfss STATUS,Z
        goto ACTIVEMODEROUTE ; otherwise continue
        call CLEARSCREEN
        goto ACTIVEMODEROUTE

RECEIVESTATIC:          ; 22 tell slaves to expect static data
        movlw 22
        call TXBYTE
        goto MOVINGMODE2

CLEARSCREEN:
        clrf COLUMN0A
        clrf COLUMN1A
        clrf COLUMN2A
        clrf COLUMN3A
        clrf COLUMN4A
        clrf COLUMN5A
        movlw %10000000  ; set display cathode 4 high (RA7)
        movwf PORTA      ; and all transistors off (low)
        movlw 255
        movwf PORTB      ; set all display cathodes high

        clrf STORECOL1
        clrf STORECOL2
        clrf STORECOL3
        clrf STORECOL4
        clrf STORECOL5
        return

SHOWSYNC: movlw 23
        call TXBYTE
        call CLEARSCREEN

        movf SYNCFLAG,W
        movwf COLUMN1A
        movwf COLUMN2A
        movwf COLUMN3A
        movwf COLUMN4A
        movwf COLUMN5A
SHOWSYNC2: call SHOWCHAR2
        movf RCFLAG,W     ;
        btfsc STATUS,Z    ; is a command recd ?
        goto SHOWSYNC2    ; no, so continue
        btfsc RCFLAG,7    ; is normal data coming in?
        goto SHOWSYNC2    ; yes, so continue
        movf RCFLAG,W     ; no, it's a command
        movwf STORE1      ; action command val and route it
        goto ROUTEITRUNMODE

        END
