;  SIRC Infra-red decoding program.
;  Written by Roger Thomas.

	list p=16C84
	__config H'3FF9'

RTCC	EQU H'01' ; timer
STATUS	EQU H'03' ; register
C	EQU H'00' ; carry flag
Z	EQU H'02' ; zero flag
PORTB	EQU H'06'
RB0	EQU H'00' ; IR input
RB1	EQU H'01' ; led
RB2	EQU H'02' ; led
INTCON	EQU H'0B' ; register
OPT	EQU H'01' ; register
TEMP0	EQU H'10'  
TEMP1	EQU H'11'
IRQ_W	EQU H'12' ; interrupt
IRQ_S	EQU H'13' ; interrupt
IRQ_STK	EQU H'14' ; interrupt
TIMERVAL	EQU H'15'  ; timer value
BITVALUE	EQU H'16'
BITS	EQU H'17' ; bit count
THISBIT	EQU H'18' ; current
CBINARY	EQU H'19' ; command
FLAG	EQU H'20' ; boolean
CONV	EQU H'01' ; flag
START	EQU H'02' ; flag

	ORG 0
	goto MAIN

	ORG 4   ; interrupt handler
	MOVWF	IRQ_W
	SWAPF	STATUS,W
	BCF	STATUS,5
	MOVWF	IRQ_S
	MOVF	TEMP0,W
	MOVWF	IRQ_STK
	CALL	INTERRUPT
	MOVF	IRQ_STK,W
	MOVWF	TEMP0
	SWAPF	IRQ_S,W
	MOVWF	STATUS
	SWAPF	IRQ_W,F
	SWAPF	IRQ_W,W
	RETFIE

MAIN	BSF	STATUS,5  ; page 1
	BSF	PORTB,RB0 ; input
	BCF	PORTB,RB1 ; output
	BCF	PORTB,RB2 ; output
	BCF	STATUS,5  ; page 0
	BCF	PORTB,RB1 ; off
	BCF	PORTB,RB2 ; off
	CLRF	FLAG      ; = 0
	CLRF	BITS      ; = 0
	BSF	STATUS,5  ; page 1
	BCF	OPT,5     ; use clock
	BSF	OPT,0     ; PS0 divide by 16
	BSF	OPT,1     ; PS1
	BCF	OPT,2     ; PS2
	BCF	OPT,3     ; PSA
	BCF	OPT,6     ; interrupt falling edge 
	BCF	STATUS,5  ; page 0
	BSF	INTCON,4  ; RB0 interrupt source
	BSF	INTCON,7  ; enable interrupt

LOOP	BTFSS	FLAG,CONV
	GOTO	LOOP1
	CALL	CONVRTCC  ; CONV flag = 1
	GOTO	LOOP
LOOP1	BTFSS	INTCON,2  ; timer overflow
	GOTO	LOOP
	BCF	INTCON,2  ; clear flag
; if bits >= 12
	MOVF	BITS,W
	MOVWF	TEMP0
	MOVLW	H'0C' ; 12
	SUBWF	TEMP0,W
	CLRW
	BTFSC	STATUS,C
	ADDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	LOOP
	CALL	LEDDISPLAY ; output
	BCF	FLAG,START ; clr flag
	CLRF	BITS       ; = 0
	CLRF	CBINARY    ; = 0
	GOTO	LOOP

INTERRUPT
	MOVF	RTCC,W     ; read timer
	MOVWF	TIMERVAL   ; = timer
	CLRF	RTCC       ; zero timer
	BCF	INTCON,1   ; clear RB0 flag
	BSF	FLAG,CONV  ; set data flag
	RETURN

CONVRTCC	BCF	FLAG,CONV ; clear flag
	INCF	BITS,F     ; bits+1
	BTFSS	FLAG,START ; start ?
	GOTO	TV150
; if start = 1
; if timerval > 90 and <= 150
	MOVF	TIMERVAL,W
	SUBLW	H'5A' ; 90
	CLRW
	BTFSS	STATUS,C
	ADDLW	H'FF'
	MOVWF	TEMP1
	MOVF	TIMERVAL,W
	SUBLW	H'96' ; 150
	CLRW
	BTFSC	STATUS,C
	ADDLW	H'FF'
	ANDWF	TEMP1,W
	BTFSC	STATUS,Z
	GOTO	TV5090
	MOVLW	H'01'
	MOVWF	THISBIT
	CALL	ADDTOBINARY
; if timerval >= 50 and <= 90
TV5090	MOVF	TIMERVAL,W
	MOVWF	TEMP0
	MOVLW	H'32' ; 50
	SUBWF	TEMP0,W
	CLRW
	BTFSC	STATUS,C
	ADDLW	H'FF'
	MOVWF	TEMP1
	MOVF	TIMERVAL,W
	SUBLW	H'5A' ; 90
	CLRW
	BTFSC	STATUS,C
	ADDLW	H'FF'
	ANDWF	TEMP1,W
	BTFSC	STATUS,Z
	GOTO	TV150
	MOVLW	H'00'
	MOVWF	THISBIT
	CALL	ADDTOBINARY
; if timerval > 150 
TV150	MOVF	TIMERVAL,W
	SUBLW	H'96' ; 150
	CLRW
	BTFSS	STATUS,C
	ADDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	ENDCONV
	BSF	FLAG,START
	MOVLW	H'01'
	MOVWF	BITVALUE ; =1
	CLRF	CBINARY
ENDCONV	RETURN

ADDTOBINARY
	MOVF	BITS,W
	SUBLW	H'08'
	CLRW
	BTFSC	STATUS,C
	ADDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	ENDADD
; bits <= 8
; if thisbit = 0
	MOVF	THISBIT,W
	SUBLW	H'00'
	MOVLW	H'00'
	BTFSC	STATUS,Z
	ADDLW	H'FF'
	ANDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	ADDBIN
	BCF	STATUS,C
	RLF	BITVALUE,F
	GOTO	ENDADD
; cbinary = cbinary OR bitvalue 
ADDBIN	MOVF	CBINARY,W
	IORWF	BITVALUE,W
	MOVWF	CBINARY
	BCF	STATUS,C
	RLF	BITVALUE,F
ENDADD	RETURN

LEDDISPLAY
; if cbinary = 18 [vol +]
	MOVF	CBINARY,W
	SUBLW	H'12' ; 18
	MOVLW	H'00'
	BTFSC	STATUS,Z
	ADDLW	H'FF'
	ANDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	CBIN19
	BSF	PORTB,RB1 ; on
	BCF	PORTB,RB2 ; off
; if cbinary = 19 [vol -]
CBIN19	MOVF	CBINARY,W
	SUBLW	H'13' ; 19
	MOVLW	H'00'
	BTFSC	STATUS,Z
	ADDLW	H'FF'
	ANDLW	H'FF'
	BTFSC	STATUS,Z
	GOTO	DONE
	BCF	PORTB,RB1 ; off
	BSF	PORTB,RB2 ; on
DONE	RETURN

	END
