; CARILLONMAIN831.ASM 05APR07 - CARILLON - ALL FUNCTIONS

#DEFINE BANK0 BCF STATUS,5
#DEFINE BANK1 BSF STATUS,5

    list p=16f628, r=dec
    include p16f628.inc

    __config  H'3F22' ; 20MHz

        CBLOCK H'20'

DELAYSTORE
CLKCNT

NOTESTORE1
NOTESTORE2
NOTESTORE3
NOTESTORE4
NOTESTORE5

VALB
VALB2
VALC
STORE

BELLCNT1                 ; BELLVALMSB1 additive value added to this value
BELLCNT2
BELLCNT3
BELLCNT4
BELLCNT5
                         
BELLVALMSB1              ; additive value
BELLVALMSB2
BELLVALMSB3
BELLVALMSB4
BELLVALMSB5

BELLVALLSB1
BELLVALLSB2
BELLVALLSB3
BELLVALLSB4
BELLVALLSB5

NOTEVAL
RATE
RATESTOREMSB
RATESTORELSB
RATEVALMSB
RATEVALLSB

CHORDNOTE
TEMPNOTE
ENVFLAG
NOTELENGTH
ENDLENGTH
PREVIOUS
SERIALNOTEVAL
CHOSEN                   ; shows if this path is in use
TUNINGFLAG               ; used by author only

COL                      ;column counter (inc in decimal)
ROW                      ;row counter (inc as matrix val)
ANSWER                   ;holds final keyed answer
STORE2
LOOP
OCTAVEVAL
DOORBELLCNT
SWITCH
ELOOP

	ENDC

PROMVAL EQU H'70'         ; in both pages
SPBRG   EQU H'99'         ; not in INC file for some odd reason.  Bank 1

; BITS 
MATRIX  EQU 4     ;matrix quantity value
                   ;set as 3 for (3 x 4)
                   ; or as 4 for (4 x 4)

        ORG 0
        goto GIEOFF
        ORG 4            ; Interrupt vector address
        goto GIEOFF
        ORG 5

GIEOFF: BCF INTCON,GIE   ; turn off global interrupts
        BTFSC INTCON,GIE
        goto GIEOFF
        goto STARTIT

BELLFREQMSB: movf NOTEVAL,W
	andlw 15
        addwf PCL,F
        retlw 0   ; 0  nil 
        retlw 2 ; * 440  1 A  ; vals for octave 1 shown
        retlw 2 ; * 466  2 As
        retlw 2 ; * 493  3 B
        retlw 2 ; * 523  4 C
        retlw 2 ; * 554  5 Cs
        retlw 2 ; * 587  6 D
        retlw 2 ; * 622  7 Ds
        retlw 2 ; * 659  8 E
        retlw 3 ; * 699  9 F
        retlw 3 ; * 739  10 Fs
        retlw 3 ; * 784  11 G
        retlw 3 ; * 830  12 Gs
        retlw 0 ; 13
        retlw 0 ; 14
        retlw 0 ; 15

BELLFREQLSB: movf NOTEVAL,W
	andlw 15
        addwf PCL,F
        retlw 0   ; 0  nil 
        retlw 0   ; 1  A (440)
        retlw 31  ; 2  As
        retlw 64  ; 3  B
        retlw 97  ; 4  C
        retlw 132 ; 5  Cs
        retlw 170 ; 6  D
        retlw 211 ; 7  Ds
        retlw 255 ; 8  E
        retlw 45  ; 9  F
        retlw 92  ; 10 Fs
        retlw 143 ; 11 G
        retlw 198 ; 12 Gs
        retlw 0   ; 13
        retlw 0   ; 14
        retlw 0   ; 15

SETRATE: movf RATE,W

        addlw 1   ; intentionally add 1 octave

        andlw 7
        addwf PCL,F
        goto RATE0  ; 0 octave / 8
        goto RATE1  ; 1 octave / 4
        goto RATE2  ; 2 octave / 2
        goto RATE3  ; 3 octave x 1
        goto RATE4  ; 4 octave x 2
        goto RATE5  ; 5 octave x 4 
        goto RATE6  ; 6 octave x 8 
        goto RATE7  ; 7 octave x 16

SETLEN: movlw 2     ; sets trigger on time always fixed
        addwf PCL,F     ; ignore note types - irrelevant to struck notes
        retlw 0         ; 0  nil
        retlw 2         ; 1  demisemiquaver
        retlw 4         ; 2  semiquaver
        retlw 8         ; 3  quaver
        retlw 32        ; 4  minim      ; 4 & 5 vals swapped because PC select
        retlw 16        ; 5  crotchet   ; keys 4 & 5 swapped
        retlw 64        ; 6  semibreve
        retlw 128       ; 7  breve
        retlw 3         ; 8  demisemiquaver dotted
        retlw 6         ; 9  semiquaver dotted
        retlw 12        ; 10 quaver dotted
        retlw 24        ; 11 crotchet dotted
        retlw 48        ; 12 minim dotted
        retlw 96        ; 13 semibreve dotted
        retlw 192       ; 14 breve dotted
        retlw 192

DOORTRIG: addwf PCL,F   ; Table for automatic doorbell theme. In this case
                        ; just 2 notes, D, A. Others can be added within
                        ; the normal PCLATH page limits
                        ; MSB = Octave  LSB = Note
;        retlw B'01000110' ; D (oct 4, note 6)
        retlw B'00110001' ; A (oct 3, note 1)
        retlw B'01000001' ; A (oct 4, note 1)

SETCHORD: btfss TUNINGFLAG,0 ; is tuning needed?
        goto GETSERIAL       ; no
                             ; yes (monitored on RB6) (author's use only)
        movlw B'01010001'     ; "A" (LSB) octave 5 (MSB)
        movwf SERIALNOTEVAL
        bsf ENVFLAG,0
        return

VALUE:  ADDWF PCL,F       ;lookup table for note/key allocation
        include CarillonKeypadNotes.inc

;**************

STARTIT: clrf PORTA
        clrf PORTB
        movlw H'07'
        movwf CMCON

	BANK1
        movlw B'00001110'    ; RB1 & RB2 for serial
        movwf TRISB          ; RB3 for PIC mode use, others all outputs
        movlw B'00010000'
        movwf TRISA

        movlw B'00000111'    ; set timer ratio 1:256, pull-ups on
        movwf OPTION_REG
        BANK0

        clrf INTCON
        call PAUSIT
        clrf STATUS          ; Select bank 0
        clrf INTCON          ; No interrupts
        clrf PCLATH          ; Code is in first bank
        clrf CLKCNT
        clrf ENVFLAG
        clrf PREVIOUS
        clrf SERIALNOTEVAL
        clrf CHOSEN          ; clear Chosen for this path
        call JOESETBAUD

        clrf TUNINGFLAG
;        bsf TUNINGFLAG,0     ; used only by author

        btfsc PORTB,3        ; is this the Keypad Interface (RB3 high) ?
        goto KEYPAD          ; yes
;        goto DOORBELL

; NB - if wished, the "goto KEYPAD" can be changed to "goto DOORBELL"
; see EPE text

        btfsc PORTA,4        ; is this the PolyP Interface (RA4 high) ?
        goto INTERFACE       ; yes

;*****************************************************************************

ST1:    clrf NOTESTORE1
        clrf NOTESTORE2
        clrf NOTESTORE3
        clrf NOTESTORE4
        clrf NOTESTORE5

        clrf BELLCNT1
        clrf BELLCNT2
        clrf BELLCNT3
        clrf BELLCNT4
        clrf BELLCNT5

        call SETLEN         ; sets env turn on time
        movwf NOTELENGTH
        movlw 20            ;40
        movwf ENDLENGTH     ; sets period before which another note cannot
        call SETCHORD       ; be received 

        movf SERIALNOTEVAL,W
        movwf CHORDNOTE
        call STRIKENOTEBLANK

; ***********

ST2:     movf BELLCNT1,W
;        movf BELLCNT5,W

        call PRMGET
        btfss TUNINGFLAG,0  ; is tuning needed?
        call DIVIDE8        ; no
        movwf VALB

        movf BELLCNT2,W
        call PRMGET
        call DIVIDE8
        btfss TUNINGFLAG,0  ; is tuning needed?
        addwf VALB,F        ; no
        addwf VALC,F        ; yes (bypassing VALB)

        movf BELLCNT3,W
        call PRMGET
        call DIVIDE8
        btfss TUNINGFLAG,0  ; is tuning needed?
        addwf VALB,F        ; no
        addwf VALC,F        ; yes (bypassing VALB)

        movf BELLCNT4,W
        call PRMGET
        call DIVIDE8
        btfss TUNINGFLAG,0  ; is tuning needed?
        addwf VALB,F        ; no
        addwf VALC,F        ; yes (bypassing VALB)

        movf BELLCNT5,W
        call PRMGET
        call DIVIDE8
        btfss TUNINGFLAG,0  ; is tuning needed?
        addwf VALB,F        ; no
        addwf VALC,F        ; yes (bypassing VALB)

        btfsc CHORDNOTE,7   ; is bit 7 = 0?
        goto COMBINED       ; no = 128, therefore a chord note
        movf VALB,W
        movwf VALB2
        goto STK1

COMBINED: movf VALB,W
        addwf VALB2,F

STK1:   movf VALB2,W        ; get LSB
        andlw B'00001111'   ; LSB out to PORTA
        movwf PORTA

ST2K:   movf VALB2,W        ; get VALB2
        andlw B'11110000'   ; knock out LSB
        iorwf ENVFLAG,W     ; set env shaper
        movwf PORTB         ; put it out to PORTB

STK3:   call DELAY440
        call DOBELL1
        call DOBELL2
        call DOBELL3
        call DOBELL4
        call DOBELL5

        call SETCHORD       ; new note if available

        movf SERIALNOTEVAL,W
        call STRIKENOTEBLANK
        goto ST2

DIVIDE8:  movwf STORE       ; divide amplitude by 8
        bcf STATUS,C        ; to allow 5 partials simultaneously
        rrf STORE,F
        bcf STATUS,C
        rrf STORE,F
        bcf STATUS,C
        rrf STORE,W
        return

; **********

DOBELL1: movf BELLVALMSB1,W ; additive value
        addwf BELLCNT1,F    ; additive value added to this value
        movf BELLVALLSB1,W 
        addwf NOTESTORE1,F
        movf STATUS,W
        andlw 1
        addwf BELLCNT1,W
        andlw 127
        movwf BELLCNT1
        return

DOBELL2: movf BELLVALMSB2,W
        addwf BELLCNT2,F
        movf BELLVALLSB2,W 
        addwf NOTESTORE2,F
        movf STATUS,W
        andlw 1
        addwf BELLCNT2,W
        andlw 127
        movwf BELLCNT2
        return

DOBELL3: movf BELLVALMSB3,W
        addwf BELLCNT3,F
        movf BELLVALLSB3,W 
        addwf NOTESTORE3,F
        movf STATUS,W
        andlw 1
        addwf BELLCNT3,W
        andlw 127
        movwf BELLCNT3
        return

DOBELL4: movf BELLVALMSB4,W
        addwf BELLCNT4,F
        movf BELLVALLSB4,W 
        addwf NOTESTORE4,F
        movf STATUS,W
        andlw 1
        addwf BELLCNT4,W
        andlw 127
        movwf BELLCNT4
        return

DOBELL5: movf BELLVALMSB5,W
        addwf BELLCNT5,F
        movf BELLVALLSB5,W 
        addwf NOTESTORE5,F
        movf STATUS,W
        andlw 1
        addwf BELLCNT5,W
        andlw 127
        movwf BELLCNT5
        return

;*****************************************************************************

PAUSIT: movlw 20           ; 1/5th sec wait set at 20MHz
        movwf CLKCNT
        clrf INTCON        ; clear interupt flag
PAUSE:  btfss INTCON,2     ; has a timer time-out been detected?
        goto PAUSE         ; no
        bcf INTCON,2       ; yes
        decfsz CLKCNT,F    ; dec loop, is it zero?
        goto PAUSE         ; no
        return             ; yes

;*****************************************************************************

PAUSIT2:
PAUSE2:  btfss INTCON,2    ; has a timer time-out been detected?
        return             ; no 
        bcf INTCON,2       ; yes
        incf CLKCNT,F      ; inc CLKCNT

        movf CLKCNT,W
        xorwf NOTELENGTH,W
        btfsc STATUS,Z
        call ENDENV        ; turns off env trig, but leaves freq running

        movf CLKCNT,W
        xorwf ENDLENGTH,W
        btfss STATUS,Z
        return
        clrf CHOSEN        ; clear CHOSEN to allow receipt of next note available
        return             ; but leaves freq running

ENDENV: btfss TUNINGFLAG,0 ; is TuningFlag set ?
        bcf ENVFLAG,0      ; Tuning not needed so turn off ENVFLAG
        return

;*****************************************************************************

PAUSIT3: movlw 30          ; set your own value here
        movwf CLKCNT
        clrf INTCON        ; clear interupt flag
PAUSE3: btfss INTCON,2     ; has a timer time-out been detected?
        goto PAUSE3        ; no
        bcf INTCON,2       ; yes
        decfsz CLKCNT,F    ; dec loop, is it zero?
        goto PAUSE3        ; no
        return             ; yes

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F62x devices ****
;         the data sheet page 93 is wrong!  This routine here works!

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf EECON1,RD   ;enable read flag
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        BANK0
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F62x devices ********
          ;according to data sheet page 93 (is the same as for 16F87x devices
	  ; except that PIR2 of '87x has become PIR1 for '62x and page 2/3 not used)
	
                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in PROMVAL, which is located in both pages at or above $70
SETPRM: BANK1
        movwf EEADR     ;copy W into EEADR to set eeprom address
        movf PROMVAL,W  ;get data value from PROMVAL and hold in W
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw H'55'     ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw H'AA'       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        BANK0

CHKWRT: btfss PIR1,EEIF ;wait until bit 4 of PIR1 is set
        goto CHKWRT
        bcf PIR1,EEIF   ;clear bit 4 of PIR1
        return
; **********

DELAY440: clrf DELAYSTORE  ; sets overall tuning range
        movlw 135
        movwf DELAYSTORE
D440:   decfsz DELAYSTORE,F
        goto D440
        goto PAUSIT2

;**********

BELLNOTE1: call BELLFREQMSB
	movwf RATESTOREMSB
        call BELLFREQLSB
	movwf RATESTORELSB
        movwf RATE
	call SETRATE
	movf RATEVALMSB,W
        movwf BELLVALMSB1
        return

BELLNOTE2: movf RATEVALLSB,W
        movwf BELLVALLSB1
        call BELLFREQMSB
	movwf RATESTOREMSB
        call BELLFREQLSB
	movwf RATESTORELSB
	call SETRATE
	movf RATEVALMSB,W
        movwf BELLVALMSB2
	movf RATEVALLSB,W
        movwf BELLVALLSB2
        return

BELLNOTE3: call BELLFREQMSB
	movwf RATESTOREMSB
        call BELLFREQLSB
	movwf RATESTORELSB
	call SETRATE
	movf RATEVALMSB,W
        movwf BELLVALMSB3
	movf RATEVALLSB,W
        movwf BELLVALLSB3
        return

BELLNOTE4: call BELLFREQMSB
	movwf RATESTOREMSB
        call BELLFREQLSB
	movwf RATESTORELSB
	call SETRATE
	movf RATEVALMSB,W
        movwf BELLVALMSB4
	movf RATEVALLSB,W
        movwf BELLVALLSB4
        return

BELLNOTE5: call BELLFREQMSB
	movwf RATESTOREMSB
        call BELLFREQLSB
	movwf RATESTORELSB
	call SETRATE
	movf RATEVALMSB,W
        movwf BELLVALMSB5
	movf RATEVALLSB,W
        movwf BELLVALLSB5
        return

; ********

RATE0:  bcf STATUS,C         ; divide rate (octave) by 8
        rrf RATESTOREMSB,W   ; /2
        movwf RATEVALMSB
	rrf RATESTORELSB,W
	movwf RATEVALLSB
        bcf STATUS,C         ; /4
        rrf RATEVALMSB,F
        rrf RATEVALLSB,F
        bcf STATUS,C         ; /8
        rrf RATEVALMSB,F
        rrf RATEVALLSB,F
	return

RATE1:  bcf STATUS,C         ; divide rate (octave) by 4
        rrf RATESTOREMSB,W   ; /2
        movwf RATEVALMSB
	rrf RATESTORELSB,W
	movwf RATEVALLSB
        bcf STATUS,C         ; /4
        rrf RATEVALMSB,F
        rrf RATEVALLSB,F
	return

RATE2:  bcf STATUS,C         ; divide rate (octave) by 2
	rrf RATESTOREMSB,W
	movwf RATEVALMSB
	rrf RATESTORELSB,W
	movwf RATEVALLSB
        movf RATEVALMSB,W
	return

RATE3:  movf RATESTORELSB,W  ; rate remains the same (x1)
        movwf RATEVALLSB
        movf RATESTOREMSB,W
        movwf RATEVALMSB
	return

RATE4:  bcf STATUS,C         ; multiply rate (octave) by 2
        rlf RATESTORELSB,W
        movwf RATEVALLSB
        rlf RATESTOREMSB,W
        movwf RATEVALMSB
	return

RATE5:  bcf STATUS,C         ; multiply rate (octave) by 4
        rlf RATESTORELSB,W   ; x 2
        movwf RATEVALLSB
        rlf RATESTOREMSB,W
        movwf RATEVALMSB
        bcf STATUS,C         ; x 4
        rlf RATEVALLSB,F
        rlf RATEVALMSB,F
	return

RATE6:  bcf STATUS,C         ; multiply rate (octave) by 8
        rlf RATESTORELSB,W   ; x 2
        movwf RATEVALLSB
        rlf RATESTOREMSB,W
        movwf RATEVALMSB
        bcf STATUS,C         ; x 4
        rlf RATEVALLSB,F
        rlf RATEVALMSB,F
        bcf STATUS,C         ; x 8
        rlf RATEVALLSB,F
        rlf RATEVALMSB,F
	return

RATE7:  bcf STATUS,C         ; multiply rate (octave) by 16
        rlf RATESTORELSB,W   ; x 2
        movwf RATEVALLSB
        rlf RATESTOREMSB,W
        movwf RATEVALMSB
        bcf STATUS,C         ; x 4
        rlf RATEVALLSB,F
        rlf RATEVALMSB,F
        bcf STATUS,C         ; x 8
        rlf RATEVALLSB,F
        rlf RATEVALMSB,F
        bcf STATUS,C         ; x 16
        rlf RATEVALLSB,F
        rlf RATEVALMSB,F
	return

; ********

STRIKENOTEBLANK:         ; assemble harmonics
        movf SERIALNOTEVAL,W
        movwf TEMPNOTE   ; store for sake of octave in MSB

BN1:    addlw 4          ; add displacement for 1st partial
        andlw 15         ; return to LSB length
        movwf NOTEVAL    ; store in NOTEVAL
        swapf TEMPNOTE,W ; get octave from MSB
        andlw 15
        movwf TEMPNOTE
        movlw 1          ; 1 octave lower
        subwf TEMPNOTE,W
        movwf RATE       ; store in RATE
        call BELLNOTE1
        movf SERIALNOTEVAL,W
        movwf TEMPNOTE   ; store for sake of octave in MSB

BN2:    addlw 11         ; add displacement for 2nd partial
        andlw 15         ; return to LSB length
        movwf NOTEVAL    ; store in NOTEVAL
        swapf TEMPNOTE,W ; get octave from MSB
        andlw 15
        movwf TEMPNOTE
        movlw 1
        subwf TEMPNOTE,W ; 1 octave lower
        movwf RATE       ; store in RATE
        call BELLNOTE2
        movf SERIALNOTEVAL,W
        movwf TEMPNOTE   ; store for sake of octave in MSB

BN3:    addlw 4          ; add displacement for 3rd partial
        andlw 15         ; return to LSB length
        movwf NOTEVAL    ; store in NOTEVAL
        swapf TEMPNOTE,W ; get octave from MSB
        andlw 15         ; same octave
        movwf RATE       ; store in RATE
        call BELLNOTE3
        movf SERIALNOTEVAL,W
        movwf TEMPNOTE   ; store for sake of octave in MSB

BN4:    addlw 9          ; add displacement for 4th partial
        andlw 15         ; return to LSB length
        movwf NOTEVAL    ; store in NOTEVAL
        swapf TEMPNOTE,W ; get octave from MSB
        andlw 15         ; same octave
        movwf RATE       ; store in RATE
        call BELLNOTE4
        movf SERIALNOTEVAL,W
        movwf TEMPNOTE   ; store for sake of octave in MSB

BN5:    addlw 0          ; add displacement for 5th partial
        andlw 15         ; return to LSB length
        movwf NOTEVAL    ; store in NOTEVAL
        swapf TEMPNOTE,W ; get octave from MSB
        andlw 15
        movwf TEMPNOTE   ; same octave
        movlw 1
        addwf TEMPNOTE,W ; 1 octave higher
        movwf RATE       ; store in RATE
        call BELLNOTE5
        return

       ;*************** SERIAL PORT ************

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

JOESETBAUD
        BANK1                   ; Configure the baud rate generator
        movlw 129               ; BRG for 9600baud from 20MHz, brgh=1
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TXBYTE
        nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TXBYTE          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
	movf    RCREG,W
        return

GETSERIAL:
        btfss PIR1,RCIF         ; Check for any RX'd data
        return
        movf RCREG,W
        movwf STORE

        andlw B'00001111' ; is LSB=0?
        btfsc STATUS,Z
        return            ; yes

GS1:    swapf STORE,W
        andlw B'00001111' ; is MSB=0?
        btfsc STATUS,Z
        return            ; yes

        movf STORE,W
        andlw B'01111111'
        btfsc CHOSEN,0    ; is path in use?
        goto SENDON       ; yes

        movwf SERIALNOTEVAL  ; no, so update note
        bsf ENVFLAG,0
        bsf CHOSEN,0
        clrf CLKCNT
        return

SENDON: call TXBYTE       ; send on to next PIC
        clrf CLKCNT
        return

; ***********

; CARILONINTERFACE20.ASM 22MAR07 - Carillon PC Interface

INTERFACE: BANK1
        movlw B'00001111'   ; RA0-RA3 input from POLYP, others not used
        movwf TRISA
        movlw B'11110110'   ; RB1 & RB2 for serial, RB0 & RB3 o/p (but not used)
        movwf TRISB         ; RB4-RB7 input from PolyP
        BANK0
        clrf ELOOP
        clrf PREVIOUS

RXTX:   movf PORTA,W        ; get data from RA0-3 & RB4-7
        andlw B'00001111'
        movwf STORE
        movf PORTB,W
        andlw B'11110000'
        iorwf STORE,F
        btfsc STATUS,Z
        goto RXTX

        movf STORE,W
        movwf PROMVAL

        xorwf PREVIOUS,W    ; is it the same as the previous data?
        btfsc STATUS,Z
        goto RXTX           ; yes, so ignore
        movf STORE,W        ; no so store as new PREVIOUS & TX it
        movwf PREVIOUS    

        call TXBYTE         ; no, so TX via serial to 1st D-A & Env Shaper board
        goto RXTX

; *****************

;ADAPTED FROM PICKEY50.ASM 13JUL00 - JOHN BECKER - EPE PIC + KEYPAD DEMO

KEYPAD: BANK1
        clrf TRISA           ; set PORTA as outputs
        movlw B'11111110'    ; RB1 & RB2 for serial
        movwf TRISB          ; RB3 for PIC mode use, RB4-RB7 keypad input
        BANK0
        call PAUSIT
        clrf LOOP
        clrf PREVIOUS
        movlw B'00110000' 
        movwf OCTAVEVAL

MAINPROG:
         call GETKEY
         goto MAINPROG

;..........GET KEYPAD VAL ROUTINE........

GETKEY:  clrf PORTA       ; all PORTA low
         nop              ; pause to allow PORTA to stabilise
         comf PORTB,W     ; get & invert PORTB
         movwf STORE2
         swapf STORE2,W   ; swap nibbles
         andlw 15         ; isolate bits 0-3
         btfss STATUS,Z   ; is result NOT zero (keys pressed)?
         goto GK1
         clrf PREVIOUS  ; 11.12
         return           ; no, no key pressed so return to main prog

GK1:     movlw B'00000111'; yes, a key is pressed so get it
         movwf PORTA      ; initial val for PORTA
         clrf COL

GK2:     comf PORTB,W     ; get & invert PORTB
         movwf STORE2
         swapf STORE2,W   ; swap nibbles
         andlw 15         ; isolate bits 0-3
         btfss STATUS,Z   ; is result NOT zero (keys pressed)?
         goto GK3         ; yes
         incf COL,F       ; no, inc col val
         rrf PORTA,F      ; rotate PORTA right
         btfsc STATUS,C   ; is Carry zero?
         goto GK2         ; no, so repeat
         return           ; yes, so return to main prog

GK3:     movwf STORE
         clrf ROW         ; clear row number count

GK4:     rrf STORE,F      ; rotate right PORTB store val
         btfsc STATUS,C   ; is carry flag set?
         goto SUMIT       ; yes so key pressed, go & finish answer
         movlw MATRIX
         addwf ROW,F      ; add matrix val to ROW count
         goto GK4

SUMIT:   movf COL,W
         sublw 3
         movwf COL        ; store as column
         movf ROW,W       ; sum up results to single answer
         addwf COL,W      ; add ROW to COL (total of 0-15)
         call VALUE       ; convert val to allocated table character
         movwf ANSWER     ; store it (note value)

         movf ANSWER,F    ; is 0?
         btfss STATUS,Z
         goto SUM1
         clrf PREVIOUS
	 return           ; yes

SUM1:    movf ANSWER,W    ; is answer >15  (octave val) ?
         andlw B'11110000'
         btfsc STATUS,Z
         goto SUM2        ; no, it's a note
         movf ANSWER,W    ; yes, octave val
         movwf OCTAVEVAL
         movwf PREVIOUS
         return

SUM2:    movf ANSWER,W
         iorwf OCTAVEVAL,W
         movwf ANSWER
         xorwf PREVIOUS,W
         btfsc STATUS,Z
         return

         movf ANSWER,W
         movwf PREVIOUS
         call TXBYTE
         return           ; return to main program

; **************

DOORBELL:                 ; doorbell routine - set this to your own needs - see EPE text
			  ; doorbell push-switch connects between PORTB RB7 and 0V
			  ; (PORTB pullups are active)
                          ; a separate amplifier will be needed, as with the
                          ; main unit

	BANK1
        movlw B'10000000'    ; RB7 for doorbell switch
        movwf TRISB
        BANK0

BEGIN:	CLRF DOORBELLCNT
	CLRF SWITCH
TESTIT:	BTFSC PORTB,7
	GOTO TSTPRV
	BCF SWITCH,0
	GOTO TESTIT
TSTPRV:	BTFSC SWITCH,0
	GOTO TESTIT

DOBELL: movf DOORBELLCNT,W
	call DOORTRIG
	call TXBYTE
	call PAUSIT3      ; pause between between notes (set your own value into PAUSIT3)

	INCF DOORBELLCNT,F
	MOVF DOORBELLCNT,W
	xorlw 2           ; is count 1 beyond max? (set your own suitable value for number of
			  ; DOORTRIG table commands to be called here - 2 in this example case). 
	btfss STATUS,Z
	goto DOBELL       ; no, do next note
	call PAUSIT       ; yes, pause, then wait next bell push
	CLRF DOORBELLCNT  ; clear counter
	BSF SWITCH,0      ; and bell needs to be released first to avoid retriggering same call
	GOTO TESTIT


; ******************

        org H'2100'       ; data eeprom address

        include CarillonSineVals.inc   ; sinewave data

        END

;*****************************************************************************

; TABLE OF PARTIAL NOTE VALUES

;NOTE 1      x1.5 NEAR    x2 NEAR  x2.7 NEAR  x3.3 NEAR   STRIKE NOTE
;A0   220     330 E0      440 A1    594 D1     726 F#1    F#0
;A#0  233     349 F0      466 A#1   629 D#1    769 G1     G0
;B0   247     370 F#0     494 B1    667 E1     815 G#1    G#0

;C0   262     393 G0      523 C1    707 F1     865 A2     A1
;C#0  277     415 G#0     554 C#1   748 F#1    914 A#2    A#1
;D0   294     441 A1      587 D1    794 G1     970 B2     B1
;D#0  311     466 A#1     622 D#1   840 G#1   1026 C2     C1
;E0   330     495 B1      659 E1    891 A2    1089 C#2    C#1
;F0   349     523 C1      698 F1    942 A#2   1152 D2     D1
;F#0  370     555 C#1     740 F#1   999 B2    1221 D#2    D#1
;G0   392     588 D1      784 G1   1058 C2    1294 E2     E1
;G#0  415     622 D#1     831 G#1  1120 C#2   1370 F2     F1

;A1   440     660 E1      880 A2   1188 D2    1452 F#2    F#1
;A#1  466     698 F1      932 A#2  1258 D#2   1538 G2     G1
;B1   494     740 F#1     988 B2   1334 E2    1630 G#2    G#1

***********

;STRIKE NOTES & their harmonics

; STRIKE   A1  A#1 B1  C1  C#1 D1  D#1 E1  F1  F#1 G1  G#1
; 0 ;A0
; 1 ;A#0
; 2 ;B0
; 3 ;C0    x
; 4 ;C#0       x
; 5 ;D0            x
; 6 ;D#0               x
; 7 ;E0                    x
; 8 ;F0                        x
; 9 ;F#0                           x
;10 ;G0    x                           x
;11 ;G#0       x                           x
;12
;13
;14
;15

; STRIKE   A1  A#1 B1  C1  C#1 D1  D#1 E1  F1  F#1 G1  G#1
;16 ;A1  0         x                       x
;17 ;A#1 1             x                       x 
;18 ;B1  2                 x                       x
;19 ;C1  3 x                   x
;20 ;C#1 4     x                   x
;21 ;D1  5         x                   x
;22 ;D#1 6             x                   x
;23 ;E1  7                 x                   x
;24 ;F1  8 x                   x                   x
;25 ;F#1 9     x                  x                    x
;26 ;G1  10        x                  x
;27 ;G#1 11            x                  x
;28
;29
;30
;31

; STRIKE   A1  A#1 B1  C1  C#1 D1  D#1 E1  F1  F#1 G1  G#1
;32 ;A2  0 x               x               x
;33 ;A#2 1     x               x               x
;34 ;B2  2         x               x               x
;35 ;C2  3             x               x
;36 ;C#2 4                 x               x
;37 ;D2  5                     x               x
;38 ;D#2 6                         x               x
;39 ;E2  7                             x               x
;40 ;F2  8                                 x
;41 ;F#2 9                                     x
;42 ;G2  10                                        x
;43 ;G#2 11                                            x
;44
;45
;46
;47

;***********

