	LIST	p=12C508
	LIST	r=dec

; registers --------------------------------------------------
W	EQU	0X0000
F	EQU	0X0001
FuseAddr	EQU	0xFFF
IdAddr	EQU	0x200
NoFuses	EQU	0x0FE0
LPosc	EQU	0x00
XTosc	EQU	0x01
IntRCosc	EQU	0x02
ExtRCosc	EQU	0x03
enWDT	EQU	0x04
ProtOff	EQU	0x08
ProtAll	EQU	0x00
enMCRL	EQU	0x10
MinBank0RAM	EQU	7
MinBank1RAM	EQU	7
MaxBank0RAM	EQU	0X1F
MaxBank1RAM	EQU	0x06	
MinBank2RAM	EQU	0	
MaxBank2RAM	EQU	0	
MinBank3RAM	EQU	0	
MaxBank3RAM	EQU	0	

INDF	EQU	0X0000
TMR0	EQU	0X0001
PCL	EQU	0X0002
STATUS	EQU	0X0003
FSR	EQU	0X0004
OSCCAL	EQU	0X0005
GPIO	EQU	0X0006

; variables --------------------------------------------------
	cblock	MinBank0RAM
	TimerA
	TimerB
	Light
	PrevLight
	BitVar_1
	BestLight
	LightCount
	PB
	a
	bm
	c
	Param_WaitMotors_time
	Param_WaitAntennae_time
	TempVar0_1
	endc

; constants -----------------------------------------------
IOPort	EQU	GPIO
bitM2Neg	EQU	4
bitM2Pos	EQU	5
bitM1Neg	EQU	0
bitM1Pos	EQU	1
bitLeftAntenna	EQU	2
bitRightAntenna	EQU	3
OptionValue	EQU	0x9F
bitLDR	EQU	bitLeftAntenna
bitSounder	EQU	bitLeftAntenna
IOconfig	EQU	( 1 << bitLeftAntenna ) | ( 1 << bitRightAntenna )
LeftStop	EQU	0
LeftForward	EQU	( 1 << bitM2Pos )
LeftBackward	EQU	( 1 << bitM2Neg )
RightStop	EQU	0
RightForward	EQU	( 1 << bitM1Neg )
RightBackward	EQU	( 1 << bitM1Pos )

; fuses ------------------------------------------------------
 	org 0xFFF
 	data	NoFuses + IntRCosc + ProtOff

;-------------------------------------------------------------
 	org 	0
	goto	initialise

; Procedure MeasureLight -------------------------------------
MeasureLight
	movlw	255
	movwf	IOPort
	movlw	(IOconfig&(~((1<<bitLDR))))
	tris	IOPort
	bcf	IOPort,bitLDR
	movlw	40
	movwf	TimerA
CompilerLabel_29
	movlw	255
	movwf	TimerB
CompilerLabel_34
	decfsz	TimerB
	goto	CompilerLabel_34
	decfsz	TimerA
	goto	CompilerLabel_29
	movlw	IOconfig
	tris	IOPort
	movlw	0x7F
	movwf	Light
CompilerLabel_43
	btfss	IOPort,bitLDR
	goto	CompilerLabel_49
	movlw	0x80
	addwf	Light,F
	retlw	0
CompilerLabel_49
	decfsz	Light
	goto	CompilerLabel_43
	movlw	0x7F
	movwf	Light
CompilerLabel_58
	btfss	IOPort,bitLDR
	goto	CompilerLabel_64
	retlw	0
CompilerLabel_64
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	decfsz	Light
	goto	CompilerLabel_58
	retlw	0

; WaitMotors(time) -----------------------------------------
WaitMotors
	movf	Param_WaitMotors_time,W
	movwf	TimerB
CompilerLabel_73
	movlw	0
	movwf	TimerA
CompilerLabel_78
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	decfsz	TimerA
	goto	CompilerLabel_78
	incf	c,F
	btfss	c,0
	goto	CompilerLabel_84
	movf	PB,W
	movwf	IOPort
	goto	CompilerLabel_93
CompilerLabel_84
	clrf	IOPort
CompilerLabel_93
	decfsz	TimerB
	goto	CompilerLabel_73
	retlw	0

; Procedure WaitAntennae(time) -------------------------------
WaitAntennae
	movf	Param_WaitAntennae_time,W
	movwf	TimerB
CompilerLabel_102
	movlw	0
	movwf	TimerA
CompilerLabel_107
	Nop
	Nop
	Nop
	Nop
	Nop
	Nop
	decfsz	TimerA
	goto	CompilerLabel_107
	incf	c,F
	btfss	c,0
	goto	CompilerLabel_113
	movf	PB,W
	movwf	IOPort
	goto	CompilerLabel_122
CompilerLabel_113
	clrf	IOPort
CompilerLabel_122
	Nop
	Nop
	movlw	(IOconfig&(~((1<<bitLDR))))
	tris	IOPort
	bsf	IOPort,bitLDR
	movlw	20
CompilerLabel_147
	movwf	TempVar0_1
	movlw	255
	addwf	TempVar0_1,W
	btfss	STATUS,2
	goto	CompilerLabel_147
	movlw	IOconfig
	tris	IOPort
	btfss	IOPort,bitLeftAntenna
	goto	CompilerLabel_161
	btfsc	IOPort,bitRightAntenna
	goto	CompilerLabel_162
CompilerLabel_161
	btfsc	IOPort,bitLeftAntenna
	goto	CompilerLabel_176
	movlw	(LeftBackward+RightBackward)
	movwf	PB
	movlw	200
	movwf	Param_WaitMotors_time
	call	WaitMotors
	movlw	(LeftForward+RightBackward)
	movwf	PB
	movlw	68
	movwf	Param_WaitMotors_time
	call	WaitMotors
CompilerLabel_176
	btfsc	IOPort,bitRightAntenna
	goto	CompilerLabel_216
	movlw	(LeftBackward+RightBackward)
	movwf	PB
	movlw	200
	movwf	Param_WaitMotors_time
	call	WaitMotors
	movlw	(RightForward+LeftBackward)
	movwf	PB
	movlw	68
	movwf	Param_WaitMotors_time
	call	WaitMotors
CompilerLabel_216
	goto	mainloop
CompilerLabel_162
	decfsz	TimerB
	goto	CompilerLabel_102
	retlw	0


; Main Program -----------------------------------------------
; initialisation ---------------------------------------------
initialise
	movwf	OSCCAL
	bcf	STATUS,5
	movlw	0
	tris	GPIO
	movlw	OptionValue
	Option
	clrf	BestLight
	clrf	LightCount
	clrf	PrevLight
	movlw	IOconfig
	tris	IOPort

; mainloop ---------------------------------------------------
mainloop
	call	MeasureLight
	movf	Light,W
	movwf	PrevLight
	btfss	BitVar_1,0
	goto	CompilerLabel_280
	movlw	(RightForward+LeftStop)
	movwf	PB
	goto	CompilerLabel_289
CompilerLabel_280
	movlw	(LeftForward+RightStop)
	movwf	PB
CompilerLabel_289
	movlw	100
	movwf	Param_WaitAntennae_time
	call	WaitAntennae

	call	MeasureLight
	btfsc	BitVar_1,0
	goto	CompilerLabel_307
	bsf	BitVar_1,0
	goto	CompilerLabel_308
CompilerLabel_307	bcf	BitVar_1,0
CompilerLabel_308
	movf	PrevLight,W
	subwf	Light,W
	btfsc	STATUS,0
	goto	CompilerLabel_316
	btfss	BitVar_1,0
	goto	CompilerLabel_322
	clrf	IOPort
	movlw	(IOconfig&(~((1<<bitSounder))))
	tris	IOPort
	movlw	30
	movwf	a
CompilerLabel_359
	movlw	20
	movwf	bm
CompilerLabel_364
	movf	a,W
	movwf	TempVar0_1
	movlw	20
	addwf	TempVar0_1,W
	movwf	c
CompilerLabel_369
	decfsz	c
	goto	CompilerLabel_369
	btfss	bm,0
	goto	CompilerLabel_375
	bsf	IOPort,bitSounder
	goto	CompilerLabel_376
CompilerLabel_375	bcf	IOPort,bitSounder
CompilerLabel_376
	decfsz	bm
	goto	CompilerLabel_364
	decfsz	a
	goto	CompilerLabel_359
	movlw	IOconfig
	tris	IOPort
	movlw	(RightForward+LeftStop)
	movwf	PB
	goto	CompilerLabel_389
CompilerLabel_322
	clrf	IOPort
	movlw	(IOconfig&(~((1<<bitSounder))))
	tris	IOPort
	movlw	30
	movwf	a
CompilerLabel_422
	movlw	20
	movwf	bm
CompilerLabel_427
	movlw	50
	movwf	TempVar0_1
	movf	a,W
	subwf	TempVar0_1,W
	movwf	c
CompilerLabel_432
	decfsz	c
	goto	CompilerLabel_432
	btfss	bm,0
	goto	CompilerLabel_438
	bsf	IOPort,bitSounder
	goto	CompilerLabel_439
CompilerLabel_438	bcf	IOPort,bitSounder
CompilerLabel_439
	decfsz	bm
	goto	CompilerLabel_427
	decfsz	a
	goto	CompilerLabel_422
	movlw	IOconfig
	tris	IOPort
	movlw	(LeftForward+RightStop)
	movwf	PB
CompilerLabel_389
	movlw	100
	movwf	Param_WaitAntennae_time
	call	WaitAntennae
CompilerLabel_316
	movf	Light,W
	subwf	BestLight,W	
	btfsc	STATUS,0
	goto	CompilerLabel_465
	clrf	LightCount
	movf	Light,W
	movwf	BestLight	
	goto	CompilerLabel_478
CompilerLabel_465	
	incf	LightCount,F
	movlw	20
	subwf	LightCount,W
	btfss	STATUS,2	
	goto	CompilerLabel_480
	movlw	(LeftBackward+RightBackward)
	movwf	PB	
	movlw	200
	movwf	Param_WaitMotors_time	
	call	WaitMotors
	clrf	IOPort
	movlw	(IOconfig&(~((1<<bitSounder))))
	tris	IOPort	
	movlw	30
	movwf	a	
CompilerLabel_533	
	movlw	80
	movwf	bm	
CompilerLabel_538	
	movf	a,W
	movwf	TempVar0_1
	movlw	20	
	addwf	TempVar0_1,W	
	movwf	c	
CompilerLabel_543	
	decfsz	c
	goto	CompilerLabel_543
	btfss	bm,0
	goto	CompilerLabel_549
	bsf	IOPort,bitSounder
	goto	CompilerLabel_550
CompilerLabel_549	bcf	IOPort,bitSounder	
CompilerLabel_550	
	decfsz	bm
	goto	CompilerLabel_538
	decfsz	a
	goto	CompilerLabel_533
	movlw	IOconfig
	tris	IOPort	
;       Sound(30,80,50-a)	
	clrf	IOPort
	movlw	(IOconfig&(~((1<<bitSounder))))
	tris	IOPort	
;   for a=30 	
	movlw	30	
	movwf	a	
CompilerLabel_591	
	movlw	80
	movwf	bm	
CompilerLabel_596
	movlw	50
	movwf	TempVar0_1	
	movf	a,W	
	subwf	TempVar0_1,W	
	movwf	c	
CompilerLabel_601	
	decfsz	c
	goto	CompilerLabel_601
	btfss	bm,0
	goto	CompilerLabel_607
	bsf	IOPort,bitSounder
	goto	CompilerLabel_608
CompilerLabel_607	bcf	IOPort,bitSounder	
CompilerLabel_608	
	decfsz	bm
	goto	CompilerLabel_596
	decfsz	a
	goto	CompilerLabel_591
	movlw	IOconfig
	tris	IOPort	
;       TurnToBrightest
	movlw	0xFF
	movwf	PrevLight	
CompilerLabel_621
	clrf	BestLight
	movlw	10
	movwf	LightCount	
CompilerLabel_626	
	btfss	BitVar_1,0
	goto	CompilerLabel_632
	movlw	(LeftForward+RightBackward)
	movwf	PB	
	goto	CompilerLabel_641
CompilerLabel_632	
	movlw	(RightForward+LeftBackward)
	movwf	PB	
CompilerLabel_641
	movlw	40
	movwf	Param_WaitAntennae_time	
	call	WaitAntennae
	call	MeasureLight
	movf	PrevLight,W
	subwf	Light,W	
	btfss	STATUS,0	
	goto	CompilerLabel_659
	goto	TurnToBrightest1_M38
CompilerLabel_659	
	movf	Light,W
	subwf	BestLight,W
	btfsc	STATUS,0
	goto	CompilerLabel_665
	movf	Light,W
	movwf	BestLight	
CompilerLabel_665	
	decfsz	LightCount
	goto	CompilerLabel_626
	movf	BestLight,W
	movwf	PrevLight	
	goto	CompilerLabel_621
TurnToBrightest1_M38
	btfss	BitVar_1,0
	goto	CompilerLabel_684
	movlw	(RightForward+LeftBackward)
	movwf	PB	
	goto	CompilerLabel_693
CompilerLabel_684	
	movlw	(LeftForward+RightBackward)
	movwf	PB	
CompilerLabel_693
	movlw	40
	movwf	Param_WaitMotors_time
	call	WaitMotors
	clrf	BestLight
CompilerLabel_480
CompilerLabel_478
	goto	mainloop

  END

