;PKTBS54.asm  This programme is for the POCKET BATTLESHIPS game
;35 LED matrix display with B0, B1, B2, B4, B5, B6,& B7 driving columns
;and A0, A1, A2, A3 & B3 driving rows via a lookup table.
;
;
;The timebase is provided by an R/C network. 
;
;
;************************************************************************
;
LKP     equ 0Ch ; Last Key Pressed
DYCTR1  equ 0Dh ; DelaY CounTeR1
DYCTR2  equ 0Eh ; DelaY CounTeR2
DYCTR3  equ 0Fh ; DelaY CounTeR3
AIM     equ 10h ; CURSOR POSITION register
ENMY    equ 11h ; ENEMY POSITION register
MRCH    equ 12h ; MERCHANT SHIP STATUS 0=sunk
FLASH   equ 17h
FLAG    equ 18h ;general purpose flags
STEP    equ 19h ;controls aim stepping speed 
RND     equ 1Ah ;random counter

;
        LIST P=16C54
        include "PIC.h"
;************************************************************************
;
	goto START
;************************************************************************
;
DLAY    movlw 1Fh       ;************DELAY SUBROUTINE********************
	movwf DYCTR3
DLAY3   movwf DYCTR2
DLAY2   movwf DYCTR1    
DLAY1   decfsz DYCTR1,1
	goto DLAY1
	decfsz DYCTR2
	goto DLAY2

        decfsz RND      ; generates a number 1 to 9
        retlw 00
        movlw 09h
        movwf RND
        retlw 00        ; end
;
;************************************************************************
;
DISPLY  nop             ;********LED DISPLAY SUBROUTINE******************
        movlw 00        ; SWITCH OFF ALL LINES and define all as outputs
        tris PORTA
        tris PORTB
        movlw 0FFh
        movwf PORTA
        movwf PORTB

        movlw 10h
        movwf FSR

        movf 0,w        ; DISPLAY ROW 0
        andlw 0F0h      ; mask LS bits
        xorlw 00        ; compare
        btfss STATUS,2  ; cursor in row 0?
        goto D01        ; no
        btfss FLAG,0
        goto D01
        movf 0,w        ; yes
        andlw 0Fh       ; mask MS bits
        call LOOKUP
        movwf PORTB     ; LOAD DISPLAY
   
D01     btfsc MRCH,0    ; Ship sunk?
        bcf PORTB,4     ; no - add ship
        bcf PORTB,3     ; SWITCH ON ROW0
        call DLAY
        bsf PORTB,3     ; SWITCH OFF ROW)
        movlw 0FFh
        movwf PORTB

        movf 0,w        ; DISPLAY ROW 1
        andlw 0F0       ; mask LS bits
        xorlw 10        ; compare
        btfss STATUS,2  ; cursor in row 1?
        goto D02        ; no
        btfss FLAG,0
        goto D02
        movf 0,w        ; yes
        andlw 0Fh       ; mask MS bits
        call LOOKUP
        movwf PORTB     ; LOAD DISPLAY

D02     btfsc MRCH,1    ; zero if sunk
        bcf PORTB,2     ; not sunk- add ship
        bcf PORTA,0     ; SWITCH ON ROW1
        call DLAY
        bsf PORTA,0     ; SWITCH OFF ROW1
        movlw 0FFh
        movwf PORTB

        movf 0,w        ; DISPLAY ROW 2
        andlw 0F0       ; mask LS bits
        xorlw 20        ; compare
        btfss STATUS,2  ; cursor in row 2?
        goto D03        ; no
        btfss FLAG,0
        goto D03
        movf 0,w        ; yes
        andlw 0Fh       ; mask MS bits
        call LOOKUP
        movwf PORTB     ; LOAD DISPLAY

D03     btfsc MRCH,2    ; zero if sunk
        bcf PORTB,1     ; not sunk- add ship
        bcf PORTA,3     ; SWITCH ON ROW2
        call DLAY
        bsf PORTA,3     ; SWITCH OFF ROW2
        movlw 0FFh
        movwf PORTB

        movf 0,w        ; DISPLAY ROW 3
        andlw 0F0       ; mask LS bits
        xorlw 30        ; compare
        btfss STATUS,2  ; cursor in row 3?
        goto D04        ; no
        btfss FLAG,0
        goto D04
        movf 0,w        ; yes
        andlw 0Fh       ; mask MS bits
        call LOOKUP
        movwf PORTB     ; LOAD DISPLAY

D04     btfsc MRCH,3    ; zero if sunk
        bcf PORTB,5     ; not sunk- add ship
        bcf PORTA,2     ; SWITCH ON ROW3
        call DLAY
        bsf PORTA,2     ; SWITCH OFF ROW3
        movlw 0FFh
        movwf PORTB

        movf 0,w        ; DISPLAY ROW 4
        andlw 0F0       ; mask LS bits
        xorlw 40        ; compare
        btfss STATUS,2  ; cursor in row 0?
        goto D05        ; no
        btfss FLAG,0
        goto D05
        movf 0,w        ; yes
        andlw 0Fh       ; mask MS bits
        call LOOKUP
        movwf PORTB     ; LOAD DISPLAY

D05     btfsc MRCH,4    ; zero if sunk
        bcf PORTB,0     ; not sunk- add ship
        bcf PORTA,1     ; SWITCH ON ROW4
        call DLAY
        bsf PORTA,1     ; SWITCH OFF ROW4
        movlw 0FFh
        movwf PORTB
        retlw 00h

;*************************************************************************

LOOKUP  addwf PC,1
        retlw 0DFh      
        retlw 0EFh
        retlw 0BFh
        retlw 0FEh
        retlw 0FBh
        retlw 7Fh
        retlw 0FDh

;************************************************************************
EPOS    bsf FLAG,2      ; CHANGE ENEMY/CURSOR POSITION 

        movlw ENMY
        movwf FSR       

        movlw 05h
        xorwf RND,w
        btfsc STATUS,2  ; RND=05?
        goto EPOS5      ; yes

        movlw 08h
        xorwf RND,w
        btfsc STATUS,2  ; RND=08?
        goto EPOS5      ; yes

        movlw 04h       ; no - try 04h
        xorwf RND,w
        btfsc STATUS,2  ; RND=04?
        goto EPOS4      ; yes

        movlw 09h       ; no - try 09h
        xorwf RND,w
        btfsc STATUS,2  ; RND=09?
        goto EPOS4      ; yes

        movlw 03h       ; no - try 03h
        xorwf RND,w
        btfsc STATUS,2  ; RND=03?
        goto EPOS3      ; yes

        movlw 06h       ; no - try 06h
        xorwf RND,w
        btfsc STATUS,2  ; RND=06?
        goto EPOS3      ; yes
     
        movlw 02h       ; no - try 02h
        xorwf RND,w
        btfsc STATUS,2  ; RND=02?
        goto EPOS2      ; yes

        movlw 07h       ; no - try 07h
        xorwf RND,w
        btfsc STATUS,2  ; RND=07?
        goto EPOS2      ; yes

        retlw 00
      
EPOS5   movlw 10h       ; move DOWN
        addwf 0

        movf 0,w        ; stops enemy going down too far
        andlw 0F0h
        xorlw 50h
        btfss STATUS,2
        retlw 00
        movlw 10h
        subwf 0
        retlw 00

EPOS4   movlw 01h       ; move RIGHT
        addwf 0

        movf 0,w        ; stops enemy going right too far
        andlw 0Fh
        xorlw 07h
        btfss STATUS,2
        retlw 00
        movlw 01h
        subwf 0
        retlw 00

EPOS3   movlw 10h       ; move UP
        subwf 0

        movf 0,w        ; stops enemy going up too far
        andlw 0F0h
        xorlw 0F0h
        btfss STATUS,2
        retlw 00
        movlw 10h
        addwf 0
        retlw 00

EPOS2   movlw 01h       ; move LEFT
        subwf 0

        movf 0,w        ; stops enemy going left too far
        andlw 0Fh
        xorlw 0Fh
        btfss STATUS,2
        retlw 00
        movlw 01h
        addwf 0
        retlw 00

;************************************************************************

SCAN    clrwdt          ;**********KEYBOARD SCAN SUBROUTINE**************

        movlw 07h       ; ie. 0000 0111
	tris PORTB      ; make port B0-B2 i/ps and B3-B7 o/ps
	movlw 0F0h      ; ie.  1111 0000
	movwf PORTB     ; make B4-B7 o/ps high
;
        movlw 7Fh       ; ie. 0111 1111 Make B7 LOW
	movwf PORTB
	nop

        btfsc PORTB,0   ; is UP key pressed? 
        goto SCAN1      ; no
        btfss FLAG,1    ; yes - is FLAG 1 set?
        retlw 83h       ; no

        btfsc FLAG,2    ; is FLAG2 set - change enemy position?
        retlw 83h       ; no
        call EPOS       ; yes - change ENEMY position

        movlw AIM
        movwf FSR
        call EPOS3      ; move CURSOR UP
        retlw 83

SCAN1   btfsc PORTB,2  
        goto SCAN2
        btfss FLAG,1    ; move CURSOR DOWN
        retlw 81h        

        btfsc FLAG,2
        retlw 81h
        call EPOS
                        
        movlw AIM
        movwf FSR
        call EPOS5     
        retlw 81h

SCAN2   btfsc PORTB,1   ; FIRE
        goto SCAN3
        btfss FLAG,1
        goto SCAN3
        movf AIM,w
        xorwf ENMY,w
        btfss STATUS,2  ; CURSOR on ENMY position?
        retlw 82h       ; no

        btfss RND,0     ; yes - is RND bit 0 set?
        goto SCAN6      ; no - ENEMY sunk
        movlw 40h
        movwf AIM       ; NEW SHIP
        retlw 82h

SCAN6   bsf FLAG,3      ; yes END OF GAME
        retlw 82h       ;
;
SCAN3   movlw 0DFh       ; 1101 1111
        movwf PORTB
        nop

        btfsc PORTB,0   ; is key pressed? 
        goto SCAN4      ; no
        btfss FLAG,1    ; yes - is FLAG 1 set?
        retlw 84h       ; no

        btfsc FLAG,2    ; is FLAG2 set - change enemy position?
        retlw 84h       ; no
        call EPOS       ; yes - change position

        movlw AIM
        movwf FSR
        call EPOS2      ; move CURSOR LEFT
        retlw 84h

SCAN4   btfsc PORTB,2   ; is key pressed? 
        goto SCAN5      ; no keys pressed
        btfss FLAG,1    ; yes - is FLAG 1 set?
        retlw 85h       ; no

        btfsc FLAG,2    ; is FLAG2 set - change enemy position?
        retlw 85h       ; no
        call EPOS       ; yes - change position

        movlw AIM
        movwf FSR
        call EPOS4      ; move CURSOR RIGHT
        retlw 85h

SCAN5   bcf FLAG,2      ; enable enemy position change
        movlw 01h     
        xorwf ENMY,w
        btfsc STATUS,2
        bcf MRCH,0      ; merchant ship 1 sunk

        movlw 14h
        xorwf ENMY,w
        btfsc STATUS,2
        bcf MRCH,1     ; merchant ship 2 sunk

        movlw 26h
        xorwf ENMY,w
        btfsc STATUS,2
        bcf MRCH,2     ; merchant ship 3 sunk

        movlw 30h
        xorwf ENMY,w
        btfsc STATUS,2
        bcf MRCH,3     ; merchant ship 4 sunk

        movlw 43h
        xorwf ENMY,w
        btfsc STATUS,2
        bcf MRCH,4      ; merchant ship 5 sunk

        movf MRCH
        btfsc STATUS,2  ; ALL MERCHANT SHIPS SUNK?
        bsf FLAG,3      ; yes - END GAME

        retlw 00h       ; no recognised keys pressed
;*************************************************************************
;

START   movlw 1Fh       ; merchant ship status (all not sunk)
        movwf MRCH

        movlw 40h       ; cursor position
        movwf AIM

        movlw 23h       ; enemy position
        movwf ENMY

        movlw 00
        movwf FLAG

        movlw 05h
        movwf RND

        movlw 0Fh
        movwf STEP

        tris PORTA
        tris PORTB
        movlw 0FFh
        movwf PORTA
        movwf PORTB

BEGIN   call SCAN       ; START OF MAIN PROGRAM
   
        xorwf LKP,1
        btfss STATUS,2  ; compare with previous reading (set if same)
        goto B1         ; not same
        bsf FLAG,1      ; same - set flag1
B2      movwf LKP       ; restore LKP

        call DISPLY
        btfsc FLAG,3    ; GAME OVER?
        goto ENDGM      ; yes
        decfsz FLASH    ; no
        goto BEGIN
        movlw 01h
        xorwf FLAG      ; compiment FLAG,0
        movlw 05h       ; flash speed
        movwf FLASH
        goto BEGIN

B1      bcf FLAG,1
        goto B2

ENDGM   movlw 23h
        movwf ENMY
        bsf FLAG,0
        goto B2

;************************************************************************
;
	org 1FFh
	END



