; AMBILUX70.ASM 09APR05 - COPYRIGHT JOHN BECKER - EPE PIC AMBILUX

;PIC18F242,  WDT OFF, POR ON, RC MODE

;PROGRAM WRITTEN IN TASM VARIANT - MAY NEED TRANSLATING VIA TK3 TO SUIT MPASM

        List P = PIC18F242, R=DEC;
        include P18F242.inc

	__config H'300000'  H'00'
	__config H'300001'  H'23'   RC osc
	__config H'300002'  H'08'
	__config H'300003'  H'00'
	__config H'300004'  H'00'
	__config H'300005'  H'01'
	__config H'300006'  H'80'
	__config H'300007'  H'00'
	__config H'300008'  H'0F'
	__config H'300009'  H'C0'
	__config H'30000A'  H'0F'
	__config H'30000B'  H'E0'
	__config H'30000C'  H'0F'
	__config H'30000D'  H'40'

A	equ 0  		  ; set value for Access bank bit

        CBLOCK
LOOP
STORELSB
STOREMSB
LED0
LED1
LED2
LED3
LED4
OUTPUT
MASK
CYCLEMSB
CYCLENSB
CYCLELSB
	ENDC

	org	0
	goto    START
        org     0008h       ; H'08'
        retfie
        org     0018h       ; H'18'  
        retfie              ; interrupt vector


START:  clrf PORTA,A
        clrf PORTB,A
        clrf PORTC,A
        movlw B'11011111'   ; RA0 to RA4 as input, RA5 as output
        movwf TRISA,A
        movlw B'00100000'   ; RB5 as input
;        movlw 255
        movwf TRISB,A
        clrf TRISC,A
        movlw B'10000010'   ; set RHS justify (bit 7 = 1), RA0 to RA4 as analog inputs
        movwf ADCON1,A

        movlw B'01000001'   ; set AD on (bit 0), Fosc/8 (8 & 7 = 01, & ADCON1 bit 6 = 0)
        movwf ADCON0,A

        bcf INTCON2,7,A     ; PORTB pullups on

        clrf CYCLEMSB,A
        clrf CYCLENSB,A
        clrf CYCLELSB,A

        clrf LOOP,A
        movlw B'01010101'
        movwf MASK,A
        bsf ADCON0,GO,A       ; start data conversion

;********* START OF MAIN PROGRAM ********

MAIN:   clrf LED0,A
        clrf LED1,A
        clrf LED2,A
        clrf LED3,A
        clrf LED4,A
        clrf OUTPUT,A

        btfsc PORTB,5,A     ; is cycler needed?
        goto WAITAD0        ; no

CYCLE0:; incfsz CYCLELSB,F,A ; yes, inc cycle count LSB
       ; goto CYCLE1
        incfsz CYCLENSB,F,A ; inc cycle count NSB
        goto CYCLE1
        incf CYCLEMSB,F,A   ; inc cycle count MSB
        movf CYCLEMSB,W,A   ; is CYCLEMSB = 5?
        xorlw 5
        btfsc STATUS,Z,A
        clrf CYCLEMSB,A     ; yes, clear it

CYCLE1: movf CYCLEMSB,W,A
        movwf STOREMSB,A
        movf CYCLENSB,W,A
        movwf STORELSB,A
        goto ROUTEIT

WAITAD0: btfsc ADCON0,GO,A
        goto WAITAD0
        bsf ADCON0,GO,A     ; start data conversion
        movf ADRESL,W,A     ; get ADC LSB val
        movwf STORELSB,A
        movf ADRESH,W,A     ; get ADC MSB val
        movwf STOREMSB,A

ROUTEIT: movf STOREMSB,W,A
        btfsc STATUS,Z,A
        goto SETLED0

        movf STOREMSB,W,A
        xorlw 1
        btfsc STATUS,Z,A
        goto SETLED1

        movf STOREMSB,W,A
        xorlw 2
        btfsc STATUS,Z,A
        goto SETLED2

        movf STOREMSB,W,A
        xorlw 3
        btfsc STATUS,Z,A
        goto SETLED3

        btfsc STOREMSB,2,A   ; used only in cycler
        goto SETLED4

SETLED0: comf STORELSB,W,A
        movwf LED0,A
        movf STORELSB,W,A
        movwf LED1,A
        goto LOOPIT

SETLED1: comf STORELSB,W,A
        movwf LED1,A
        movf STORELSB,W,A
        movwf LED2,A
        goto LOOPIT

SETLED2: comf STORELSB,W,A
        movwf LED2,A
        movf STORELSB,W,A
        movwf LED3,A
        goto LOOPIT

SETLED3: comf STORELSB,W,A
        movwf LED3,A
        movf STORELSB,W,A
        movwf LED4,A
        goto LOOPIT

SETLED4: comf STORELSB,W,A   ; used only in cycler
        movwf LED4,A
        movf STORELSB,W,A
        movwf LED0,A

LOOPIT: movf LED0,F,A
        btfsc STATUS,Z,A
        goto L1
        bsf OUTPUT,0,A
        decfsz LED0,F,A
        goto L1
        bcf OUTPUT,0,A

L1:     movf LED1,F,A
        btfsc STATUS,Z,A
        goto L2
        bsf OUTPUT,1,A
        decfsz LED1,F,A
        goto L2
        bcf OUTPUT,1,A

L2:     movf LED2,F,A
        btfsc STATUS,Z,A
        goto L3
        bsf OUTPUT,2,A
        decfsz LED2,F,A
        goto L3
        bcf OUTPUT,2,A

L3:     movf LED3,F,A
        btfsc STATUS,Z,A
        goto L4
        bsf OUTPUT,3,A
        decfsz LED3,F,A
        goto L4
        bcf OUTPUT,3,A

L4:     movf LED4,F,A
        btfsc STATUS,Z,A
        goto L5
        bsf OUTPUT,4,A
        decfsz LED4,F,A
        goto L5
        bcf OUTPUT,4,A

L5:     movf OUTPUT,W,A
        andwf MASK,W,A
        movwf PORTB,A
;        movwf LATB,A
        movwf PORTC,A
        comf MASK,F,A
        decfsz LOOP,F,A
        goto LOOPIT
        goto MAIN
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop


        END
