/*****************************************************************************
*   Filename:   PCADPCM.H                                                    *
******************************************************************************
*   Author:   Rodger Richey                                                  *
*   Title:    Senior Applications Manager                                    *
*   Company:  Microchip Technology Incorporated                              *
*   Revision: 1                                                              *
*   Date:     11-11-04                                                       *
******************************************************************************
* Software License Agreement												 *
*																			 *
* This software is owned by Microchip Technology Inc. ("Microchip") 		 *
* and is supplied to you for use exclusively as described in the 			 *
* associated software agreement.  This software is protected by 			 *
* software and other intellectual property laws.  Any use in 				 *
* violation of the software license may subject the user to criminal 		 *
* sanctions as well as civil liability.  Copyright 2006 Microchip			 *
* Technology Inc.  All rights reserved.										 *
*																			 *
* This software is provided "AS IS."  MICROCHIP DISCLAIMS ALL 				 *
* WARRANTIES, EXPRESS, IMPLIED, STATUTORY OR OTHERWISE, NOT LIMITED 		 *
* TO MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND 				 *
* INFRINGEMENT.  Microchip shall in no event be liable for special, 		 *
* incidental, or consequential damages.										 *
*																			 *
******************************************************************************
*   This is the header file that contains the ADPCM structure definition     *
*   and the function prototypes.                                             *
******************************************************************************
*   Revision 0  1/11/96                                                      *
*      Original release supporting only ADPCM using signed raw data          *
*      Compiled with Borland C++ Version 3.1                                 *
*   Revision 1  11/11/04                                                     *
*      Add CVSD, change ADPCM to support unsigned raw data                   *
*      Compiled using Borland C++ 6.0                                        *
*****************************************************************************/

struct ADPCMstate {
   unsigned short   prevsample;             /* Predicted sample */
   unsigned char   previndex;               /* Index into step size table */
};

/* Function prototype for the ADPCM Encoder routine */
unsigned char ADPCMEncoder(unsigned short , struct ADPCMstate *);

/* Function prototype for the ADPCM Decoder routine */
unsigned short ADPCMDecoder(unsigned char , struct ADPCMstate *);

