/**************************************************************************/
/* 	GREEN HOUSE CONTROLLER 						  */
/*	A/D Routines							  */
/**************************************************************************/

#include "green.h"


void            select(bit s3, bit s2, bit s1)
{
    lcd_wr(CMD, CLEAR);
    swen = 0;
    sel1 = s1;
    sel2 = s2;
    sel3 = s3;

}

unsigned char   a_d()
{

    unsigned char   adc_reading;


    TMOD |= 0x01;               // sets up timer 0 as a 16 bit counter
    AIN1 = 1;                   // set as input
    TL0 = TH0 = 0;              // reset timer
    AIN0 = 0;                   // start discharge
    /* change to wait */
    // for(delay_count = 0xFF;delay_count;delay_count--)
    // {;}
    wait(0x20);

    AIN0 = 1;                   // start charge cycle and timer
    TR0 = ON;

   
    while (AOUT == LOW && TF0 == LOW) 
        {;} // wait for comparator or timeout  ;}

        TR0 = OFF;

        adc_reading = TH0 << 2; // high byte of counter X4
        adc_reading |= (TL0 >> 6);  // add on  2 MSB of low byte
                                    // / low byte round up


        if (TF0 == HIGH) {      // if timer overflow (error)
            adc_reading = 0xff;
            TF0 = 0;
        }                       // can't get overflow ?
        sel1 = 1;
        sel2 = 1;
        sel3 = 1;
        swen = 1;
        return adc_reading;
    }



    /* LOOKUP ROUTINE */
/*look up starts at -10C top not important           */
        signed char     look_up(unsigned char time) {
        signed char     temp;
        extern code unsigned char temp_table[];
       //7/11/96 changed to starts at -12C was -10C. Was reporting 2C too high
                        temp = -12; /* start min temp */
        if              (time >= *(temp_table))
                            return 0xff;    /* error */
        while           (time < *(temp_table + 12 + temp))  /* add 10 to base of
                                                             * table */
              /* can no use <= we would fall of the table evan at 255*/
                            temp++; /* 0 at end of table to catch errors */
                        return temp;
    }
